/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages;

import java.util.UUID;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.NXCommon;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.MapImageDataSource;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.modules.imagelibrary.widgets.ImageSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class DCIImageGeneral
extends PropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(DCIImageGeneral.class);
    private NetworkMapDCIImage dciImage;
    private DCIImageConfiguration config;
    private DciSelector dci;
    private LabeledText column;
    private LabeledText instance;
    private ImageSelector image;
    private UUID selectedImage;

    public DCIImageGeneral(NetworkMapDCIImage dciImage) {
        super(LocalizationHelper.getI18n(DCIImageGeneral.class).tr("General"));
        this.dciImage = dciImage;
    }

    protected Control createContents(Composite parent) {
        this.config = this.dciImage.getImageOptions();
        MapImageDataSource dciConf = this.config.getDci();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.dci = new DciSelector(dialogArea, 0);
        this.dci.setLabel(this.i18n.tr("Metric"));
        if (dciConf != null) {
            this.dci.setDciId(dciConf.getNodeId(), dciConf.getDciId());
            this.dci.setDciObjectType(dciConf.getType());
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dci.setLayoutData((Object)gd);
        this.column = new LabeledText(dialogArea, 0);
        this.column.setLabel(this.i18n.tr("Column"));
        if (dciConf != null) {
            this.column.setText(dciConf.getColumn());
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.column.setLayoutData((Object)gd);
        this.instance = new LabeledText(dialogArea, 0);
        this.instance.setLabel(this.i18n.tr("Instance"));
        if (dciConf != null) {
            this.instance.setText(dciConf.getInstance());
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.instance.setLayoutData((Object)gd);
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel(this.i18n.tr("Default image"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.image.setLayoutData((Object)gd);
        this.selectedImage = this.config.getDefaultImage();
        this.image.setImageGuid(this.selectedImage, true);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.dci.getDciId() == 0L) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Metric is not selected"));
            return false;
        }
        this.selectedImage = this.image.getImageGuid();
        if (this.selectedImage == null || this.selectedImage.equals(NXCommon.EMPTY_GUID)) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Default image not selected"));
            return false;
        }
        MapImageDataSource dciConf = this.config.getDci();
        if (dciConf == null) {
            dciConf = new MapImageDataSource();
        }
        dciConf.setDciId(this.dci.getDciId());
        dciConf.setNodeId(this.dci.getNodeId());
        dciConf.setName(this.dci.getDciToolTipInfo());
        dciConf.setType(this.dci.getDciObjectType());
        dciConf.setColumn(this.column.getText());
        dciConf.setInstance(this.instance.getText());
        this.config.setDci(dciConf);
        this.config.setDefaultImage(this.selectedImage);
        this.dciImage.setImageOptions(this.config);
        return true;
    }
}

