/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkPropertyPage;
import org.netxms.nxmc.modules.networkmaps.views.helpers.LinkEditor;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class LinkGeneral
extends LinkPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(LinkGeneral.class);
    private LabeledText name;
    private LabeledText connector1;
    private LabeledText connector2;
    private ObjectSelector interface1;
    private ObjectSelector interface2;
    private LabeledCombo routingAlgorithm;
    private LabeledCombo comboLinkStyle;
    private LabeledSpinner spinerLineWidth;
    private Spinner spinnerLabelPositon;
    private Scale scaleLabelPositon;
    private Button checkExcludeFromAutomaticUpdate;

    public LinkGeneral(LinkEditor linkEditor) {
        super(linkEditor, LocalizationHelper.getI18n(LinkGeneral.class).tr("General"));
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(this.i18n.tr("Label"));
        this.name.setText(this.linkEditor.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.name.setLayoutData((Object)gd);
        Group labelPositionGroup = new Group(dialogArea, 0);
        labelPositionGroup.setText(this.i18n.tr("Label position"));
        labelPositionGroup.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        labelPositionGroup.setLayoutData((Object)gd);
        this.scaleLabelPositon = new Scale((Composite)labelPositionGroup, 256);
        this.scaleLabelPositon.setMinimum(0);
        this.scaleLabelPositon.setMaximum(100);
        this.scaleLabelPositon.setSelection(this.linkEditor.getLabelPosition());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.scaleLabelPositon.setLayoutData((Object)gd);
        this.scaleLabelPositon.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.spinnerLabelPositon = new Spinner((Composite)labelPositionGroup, 0);
        this.spinnerLabelPositon.setMinimum(0);
        this.spinnerLabelPositon.setMaximum(100);
        this.spinnerLabelPositon.setSelection(this.linkEditor.getLabelPosition());
        this.spinnerLabelPositon.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        NXCSession session = Registry.getSession();
        Group connectorGroup1 = new Group(dialogArea, 2048);
        connectorGroup1.setText(this.i18n.tr("Connector 1 \u2013 {0}", (Object)session.getObjectNameWithAlias(this.linkEditor.getElement1())));
        connectorGroup1.setLayout((Layout)new GridLayout());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        connectorGroup1.setLayoutData((Object)gd);
        this.connector1 = new LabeledText((Composite)connectorGroup1, 0);
        this.connector1.setLabel(this.i18n.tr("Name (leave empty to use interface name when interface is set)"));
        this.connector1.setText(this.linkEditor.getConnectorName1());
        this.connector1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.interface1 = new ObjectSelector((Composite)connectorGroup1, 0, true);
        this.interface1.setLabel(this.i18n.tr("Interface"));
        this.interface1.setObjectClass(Interface.class);
        this.interface1.setObjectId(this.linkEditor.getInterfaceId1());
        this.interface1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group connectorGroup2 = new Group(dialogArea, 2048);
        connectorGroup2.setText(this.i18n.tr("Connector 2 \u2013 {0}", (Object)session.getObjectNameWithAlias(this.linkEditor.getElement2())));
        connectorGroup2.setLayout((Layout)new GridLayout());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        connectorGroup2.setLayoutData((Object)gd);
        this.connector2 = new LabeledText((Composite)connectorGroup2, 0);
        this.connector2.setLabel(this.i18n.tr("Name (leave empty to use interface name when interface is set)"));
        this.connector2.setText(this.linkEditor.getConnectorName2());
        this.connector2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.interface2 = new ObjectSelector((Composite)connectorGroup2, 0, true);
        this.interface2.setLabel(this.i18n.tr("Interface"));
        this.interface2.setObjectClass(Interface.class);
        this.interface2.setObjectId(this.linkEditor.getInterfaceId2());
        this.interface2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.routingAlgorithm = new LabeledCombo(dialogArea, 0);
        this.routingAlgorithm.setLabel(this.i18n.tr("Routing algorithm"));
        this.routingAlgorithm.add(this.i18n.tr("Map default"));
        this.routingAlgorithm.add(this.i18n.tr("Direct"));
        this.routingAlgorithm.add(this.i18n.tr("Manhattan"));
        this.routingAlgorithm.add(this.i18n.tr("Bend points"));
        this.routingAlgorithm.select(this.linkEditor.getRoutingAlgorithm());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.routingAlgorithm.setLayoutData((Object)gd);
        this.comboLinkStyle = new LabeledCombo(dialogArea, 0);
        this.comboLinkStyle.setLabel(this.i18n.tr("Line style"));
        this.comboLinkStyle.add(this.i18n.tr("Map default"));
        this.comboLinkStyle.add(this.i18n.tr("Solid"));
        this.comboLinkStyle.add(this.i18n.tr("Dash"));
        this.comboLinkStyle.add(this.i18n.tr("Dot"));
        this.comboLinkStyle.add(this.i18n.tr("Dashdot"));
        this.comboLinkStyle.add(this.i18n.tr("Dashdotdot"));
        this.comboLinkStyle.select(this.linkEditor.getLineStyle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboLinkStyle.setLayoutData((Object)gd);
        this.spinerLineWidth = new LabeledSpinner(dialogArea, 0);
        this.spinerLineWidth.setLabel(this.i18n.tr("Line width (0 for map default)"));
        this.spinerLineWidth.setRange(0, 100);
        this.spinerLineWidth.setSelection(this.linkEditor.getLineWidth());
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(this.i18n.tr("Options"));
        optionsGroup.setLayout((Layout)new GridLayout());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        optionsGroup.setLayoutData((Object)gd);
        this.checkExcludeFromAutomaticUpdate = new Button((Composite)optionsGroup, 32);
        this.checkExcludeFromAutomaticUpdate.setText("Exclude from automatic updates");
        this.checkExcludeFromAutomaticUpdate.setSelection(this.linkEditor.isExcludeFromAutomaticUpdates());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.checkExcludeFromAutomaticUpdate.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void setupLayout(GridLayout layout) {
        layout.numColumns = 3;
    }

    protected boolean applyChanges(boolean isApply) {
        this.linkEditor.setName(this.name.getText());
        this.linkEditor.setConnectorName1(this.connector1.getText());
        this.linkEditor.setConnectorName2(this.connector2.getText());
        this.linkEditor.setInterfaceId1(this.interface1.getObjectId());
        this.linkEditor.setInterfaceId2(this.interface2.getObjectId());
        this.linkEditor.setRoutingAlgorithm(this.routingAlgorithm.getSelectionIndex());
        this.linkEditor.setLineStyle(this.comboLinkStyle.getSelectionIndex());
        this.linkEditor.setLineWidth(this.spinerLineWidth.getSelection());
        this.linkEditor.setLabelPosition(this.spinnerLabelPositon.getSelection());
        this.linkEditor.setExcludeFromAutomaticUpdates(this.checkExcludeFromAutomaticUpdate.getSelection());
        this.linkEditor.setModified();
        return true;
    }
}

