/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciInfo;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.client.maps.configs.MapLinkDataSource;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.propertypages.helpers.DciListLabelProvider;
import org.netxms.nxmc.modules.networkmaps.views.helpers.LinkEditor;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class DciListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private final Color systemElementColor = ThemeEngine.getForegroundColor((String)"List.DisabledItem");
    private I18n i18n = LocalizationHelper.getI18n(DciListLabelProvider.class);
    private NXCSession session = Registry.getSession();
    private Map<Long, DciInfo> dciNameCache = new HashMap();
    private List<? extends MapDataSource> elementList;
    private LinkEditor linkEditor;

    public DciListLabelProvider(List<? extends MapDataSource> elementList, LinkEditor linkEditor) {
        this.elementList = elementList;
        this.linkEditor = linkEditor;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        MapDataSource dci = (MapDataSource)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                AbstractObject object = this.session.findObjectById(dci.getNodeId());
                return object != null ? object.getObjectName() : "[" + Long.toString(dci.getNodeId()) + "]";
            }
            case 2: {
                return this.dciNameCache.get(dci.getDciId()) != null && ((DciInfo)this.dciNameCache.get((Object)Long.valueOf((long)dci.getDciId()))).displayName != null ? ((DciInfo)this.dciNameCache.get((Object)Long.valueOf((long)dci.getDciId()))).displayName : this.i18n.tr("Unresolved DCI name");
            }
            case 3: {
                return dci.getFormatString();
            }
            case 4: {
                switch (2.$SwitchMap$org$netxms$client$maps$LinkDataLocation[((MapLinkDataSource)dci).getLocation().ordinal()]) {
                    case 1: {
                        return this.i18n.tr("Center");
                    }
                    case 2: {
                        return this.session.getObjectNameWithAlias(this.linkEditor.getElement1());
                    }
                    case 3: {
                        return this.session.getObjectNameWithAlias(this.linkEditor.getElement2());
                    }
                }
            }
            case 5: {
                return ((MapLinkDataSource)dci).isSystem() ? this.i18n.tr("System") : this.i18n.tr("User");
            }
        }
        return null;
    }

    public void resolveDciNames(Collection<? extends MapDataSource> dciList) {
        new /* Unavailable Anonymous Inner Class!! */.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String name) {
        this.dciNameCache.put(dciId, new DciInfo("", name, ""));
    }

    public Color getForeground(Object element) {
        MapDataSource dci = (MapDataSource)element;
        if (dci instanceof MapLinkDataSource && ((MapLinkDataSource)dci).isSystem()) {
            return this.systemElementColor;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

