/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.views.helpers;

import java.util.List;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.MapLinkDataSource;
import org.netxms.client.maps.elements.NetworkMapObject;

public class LinkEditor {
    private NetworkMapLink link;
    private String name;
    private int type;
    private long element1;
    private long element2;
    private long interfaceId1;
    private long interfaceId2;
    private String connectorName1;
    private String connectorName2;
    private int color;
    private int colorSource;
    private String colorProvider;
    private List<Long> statusObjects;
    private int routingAlgorithm;
    private boolean modified = false;
    private List<MapLinkDataSource> dciList;
    private boolean useActiveThresholds;
    private boolean useInterfaceUtilization;
    private int labelPosition;
    private boolean disableLinkTextAutoUpdate;
    private boolean excludeFromAutomaticUpdates;
    private int lineStyle;
    private int lineWidth;

    public LinkEditor(NetworkMapLink link, NetworkMapPage mapPage, boolean disableLinkTextAutoUpdate) {
        this.link = link;
        this.name = link.getName();
        this.type = link.getType();
        this.interfaceId1 = link.getInterfaceId1();
        this.interfaceId2 = link.getInterfaceId2();
        this.element1 = ((NetworkMapObject)mapPage.getElement(link.getElement1(), NetworkMapObject.class)).getObjectId();
        this.element2 = ((NetworkMapObject)mapPage.getElement(link.getElement2(), NetworkMapObject.class)).getObjectId();
        this.connectorName1 = link.getConnectorName1();
        this.connectorName2 = link.getConnectorName2();
        this.color = link.getColor();
        this.colorSource = link.getColorSource();
        this.colorProvider = link.getColorProvider();
        this.statusObjects = link.getStatusObjects();
        this.routingAlgorithm = link.getRouting();
        this.dciList = link.getDciAsList();
        this.useActiveThresholds = link.getConfig().isUseActiveThresholds();
        this.useInterfaceUtilization = link.getConfig().isUseInterfaceUtilization();
        this.labelPosition = link.getConfig().getLabelPosition();
        this.lineStyle = link.getConfig().getStyle();
        this.lineWidth = link.getConfig().getWidth();
        this.disableLinkTextAutoUpdate = disableLinkTextAutoUpdate;
        this.excludeFromAutomaticUpdates = link.isExcludedFromAutomaticUpdate();
    }

    public boolean update(NetworkMapPage mapPage) {
        NetworkMapLink currentLink = null;
        for (NetworkMapLink l : mapPage.getLinks()) {
            if (l.getId() != this.link.getId()) continue;
            currentLink = l;
        }
        if (currentLink == null) {
            return false;
        }
        long[] bp = currentLink.getBendPoints();
        mapPage.removeLink(this.link.getId());
        this.link = new NetworkMapLink(this.link.getId(), this.name, this.type, currentLink.getElement1(), this.interfaceId1, currentLink.getElement2(), this.interfaceId2, this.connectorName1, this.connectorName2, this.dciList != null ? this.dciList.toArray(new MapLinkDataSource[this.dciList.size()]) : new MapLinkDataSource[]{}, currentLink.getFlags());
        this.link.setColor(this.color);
        this.link.setColorSource(this.colorSource);
        this.link.setColorProvider(this.colorProvider);
        this.link.setStatusObjects(this.statusObjects);
        this.link.setRouting(this.routingAlgorithm);
        this.link.setBendPoints(bp);
        this.link.getConfig().setUseActiveThresholds(this.useActiveThresholds);
        this.link.getConfig().setUseInterfaceUtilization(this.useInterfaceUtilization);
        this.link.getConfig().setLabelPosition(this.labelPosition);
        this.link.getConfig().setStyle(this.lineStyle);
        this.link.getConfig().setWidth(this.lineWidth);
        this.link.setExcludedFromAutomaticUpdate(this.excludeFromAutomaticUpdates);
        mapPage.addLink(this.link);
        this.modified = true;
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getInterfaceId1() {
        return this.interfaceId1;
    }

    public void setInterfaceId1(long interfaceId1) {
        this.interfaceId1 = interfaceId1;
    }

    public long getInterfaceId2() {
        return this.interfaceId2;
    }

    public void setInterfaceId2(long interfaceId2) {
        this.interfaceId2 = interfaceId2;
    }

    public String getConnectorName1() {
        return this.connectorName1;
    }

    public void setConnectorName1(String connectorName1) {
        this.connectorName1 = connectorName1;
    }

    public String getConnectorName2() {
        return this.connectorName2;
    }

    public void setConnectorName2(String connectorName2) {
        this.connectorName2 = connectorName2;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColorSource() {
        return this.colorSource;
    }

    public void setColorSource(int colorSource) {
        this.colorSource = colorSource;
    }

    public String getColorProvider() {
        return this.colorProvider;
    }

    public void setColorProvider(String colorProvider) {
        this.colorProvider = colorProvider;
    }

    public List<Long> getStatusObjects() {
        return this.statusObjects;
    }

    public void setStatusObjects(List<Long> statusObject) {
        this.statusObjects = statusObject;
    }

    public void addStatusObject(Long id) {
        this.statusObjects.add(id);
    }

    public void removeStatusObjectByIndex(int index) {
        this.statusObjects.remove(index);
    }

    public int getRoutingAlgorithm() {
        return this.routingAlgorithm;
    }

    public void setRoutingAlgorithm(int routingAlgorithm) {
        this.routingAlgorithm = routingAlgorithm;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public List<MapLinkDataSource> getDciList() {
        return this.dciList;
    }

    public void setDciList(List<MapLinkDataSource> dciList) {
        this.dciList = dciList;
    }

    public boolean isUseActiveThresholds() {
        return this.useActiveThresholds;
    }

    public void setUseActiveThresholds(boolean useActiveThresholds) {
        this.useActiveThresholds = useActiveThresholds;
    }

    public boolean isUseInterfaceUtilization() {
        return this.useInterfaceUtilization;
    }

    public void setUseInterfaceUtilization(boolean useInterfaceUtilization) {
        this.useInterfaceUtilization = useInterfaceUtilization;
    }

    public NetworkMapLink getLink() {
        return this.link;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int labelPosition) {
        this.labelPosition = labelPosition;
    }

    public boolean isLinkTextUpdateDisabled() {
        return this.disableLinkTextAutoUpdate;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isExcludeFromAutomaticUpdates() {
        return this.excludeFromAutomaticUpdates;
    }

    public void setExcludeFromAutomaticUpdates(boolean excludeFromAutomaticUpdates) {
        this.excludeFromAutomaticUpdates = excludeFromAutomaticUpdates;
    }

    public long getElement1() {
        return this.element1;
    }

    public long getElement2() {
        return this.element2;
    }
}

