/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.client.maps.configs.MapImageDataSource;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.networkmaps.ObjectDoubleClickHandlerRegistry;
import org.netxms.nxmc.modules.networkmaps.algorithms.ManualLayout;
import org.netxms.nxmc.modules.networkmaps.algorithms.SparseTree;
import org.netxms.nxmc.modules.networkmaps.widgets.NetworkMapWidget;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ExtendedGraphViewer;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.LinkDciValueProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapContentProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.tools.ColorConverter;
import org.xnap.commons.i18n.I18n;

public class NetworkMapWidget
extends Composite {
    protected ExtendedGraphViewer viewer;
    protected MapLabelProvider labelProvider;
    private I18n i18n = LocalizationHelper.getI18n(NetworkMapWidget.class);
    private Color defaultLinkColor = null;
    private boolean disableGeolocationBackground = false;
    private NXCSession session = Registry.getSession();
    private SessionListener sessionListener;
    private NetworkMapPage mapPage = null;
    private ObjectDoubleClickHandlerRegistry doubleClickHandlers;
    private Stack<Long> history = new Stack();
    private long currentMapId = 0L;
    private LinkDciValueProvider dciValueProvider = LinkDciValueProvider.getInstance();
    private View view;

    public NetworkMapWidget(Composite parent, int style, View view) {
        super(parent, style);
        this.view = view;
        this.disableGeolocationBackground = PreferenceStore.getInstance().getAsBoolean("NetMap.DisableGeolocationBackground", false);
        this.setLayout((Layout)new FillLayout());
        this.viewer = new ExtendedGraphViewer((Composite)this, 0, view, null);
        this.labelProvider = new MapLabelProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider(this.viewer, this.labelProvider));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.addDisposeListener((DisposeListener & Serializable)e -> {
            if (this.defaultLinkColor != null) {
                this.defaultLinkColor.dispose();
            }
            if (this.sessionListener != null) {
                this.session.removeListener(this.sessionListener);
            }
        });
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    public void enableObjectDoubleClick() {
        this.doubleClickHandlers = new ObjectDoubleClickHandlerRegistry(this.view);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void goBack() {
        if (this.history.isEmpty()) {
            return;
        }
        long submapId = (Long)this.history.pop();
        NetworkMap map = (NetworkMap)this.session.findObjectById(submapId, NetworkMap.class);
        if (map != null) {
            this.setContent(map, false);
        }
        if (this.history.isEmpty()) {
            this.viewer.hideBackButton();
        }
    }

    private void onObjectChange(AbstractObject object) {
        List links;
        if (this.mapPage == null) {
            return;
        }
        NetworkMapObject element = this.mapPage.findObjectElement(object.getObjectId());
        if (element != null) {
            this.viewer.refresh((Object)element, true);
        }
        if ((links = this.mapPage.findLinksWithStatusObject(object.getObjectId())) != null) {
            for (NetworkMapLink l : links) {
                this.viewer.refresh((Object)l);
            }
        }
    }

    public void setContent(NetworkMapPage page) {
        this.mapPage = page;
        this.addDciToRequestList();
        this.viewer.setInput((Object)page);
    }

    public void setContent(NetworkMap mapObject) {
        this.setContent(mapObject, true);
    }

    private void setContent(NetworkMap mapObject, boolean resetHistory) {
        this.syncObjects(mapObject);
        if (!mapObject.isFitToScreen()) {
            int width = mapObject.getWidth() == 0 ? this.session.getNetworkMapDefaultWidth() : mapObject.getWidth();
            int height = mapObject.getHeight() == 0 ? this.session.getNetworkMapDefaultHeight() : mapObject.getHeight();
            this.viewer.setMapSize(width, height);
        } else {
            this.viewer.setMapSize(-1, -1);
        }
        this.currentMapId = mapObject.getObjectId();
        this.setMapLayout(mapObject.getLayout());
        if (mapObject.getBackground() != null && mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(mapObject.getBackgroundLocation(), mapObject.getBackgroundZoom());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(mapObject.getBackground()), mapObject.isCenterBackgroundImage(), mapObject.isFitBackgroundImage());
            }
        }
        this.setConnectionRouter(mapObject.getDefaultLinkRouting());
        this.viewer.setBackgroundColor(ColorConverter.rgbFromInt((int)mapObject.getBackgroundColor()));
        if (mapObject.getDefaultLinkColor() >= 0) {
            if (this.defaultLinkColor != null) {
                this.defaultLinkColor.dispose();
            }
            this.defaultLinkColor = new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)mapObject.getDefaultLinkColor()));
            this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        }
        this.labelProvider.setObjectFigureType(mapObject.getObjectDisplayMode());
        this.labelProvider.setShowStatusBackground(mapObject.isShowStatusBackground());
        this.labelProvider.setShowStatusFrame(mapObject.isShowStatusFrame());
        this.labelProvider.setShowStatusIcons(mapObject.isShowStatusIcon());
        this.labelProvider.setTranslucentLabelBackground(mapObject.isTranslucentLabelBackground());
        this.labelProvider.setDefaultLinkStyle(mapObject.getDefaultLinkStyle());
        this.labelProvider.setDefaultLinkWidth(mapObject.getDefaultLinkWidth());
        this.mapPage = mapObject.createMapPage();
        this.addDciToRequestList();
        this.viewer.setInput((Object)this.mapPage);
        if (resetHistory) {
            this.history.clear();
        }
    }

    private void syncObjects(NetworkMap mapObject) {
        NetworkMapPage mapPage = mapObject.createMapPage();
        HashSet mapObjectIds = new HashSet(mapPage.getObjectIds());
        mapObjectIds.addAll(mapPage.getAllLinkStatusObjects());
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void setMapLayout(MapLayoutAlgorithm layout) {
        if (layout == MapLayoutAlgorithm.MANUAL) {
            this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new ManualLayout());
        } else {
            this.setLayoutAlgorithm(layout);
        }
    }

    public void setLayoutAlgorithm(MapLayoutAlgorithm alg) {
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)(switch (5.$SwitchMap$org$netxms$client$maps$MapLayoutAlgorithm[alg.ordinal()]) {
            case 1 -> new SpringLayoutAlgorithm();
            case 2 -> new RadialLayoutAlgorithm();
            case 3 -> new TreeLayoutAlgorithm(3);
            case 4 -> new TreeLayoutAlgorithm(1);
            case 5 -> {
                TreeLayoutAlgorithm mainLayoutAlgorithm = new TreeLayoutAlgorithm(1);
                this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
                yield new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{mainLayoutAlgorithm, new SparseTree()});
            }
            default -> new GridLayoutAlgorithm();
        }));
    }

    public void setConnectionRouter(int routingAlgorithm) {
        switch (routingAlgorithm) {
            case 2: {
                this.viewer.getGraphControl().setRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            default: {
                this.viewer.getGraphControl().setRouter(null);
            }
        }
        this.viewer.refresh();
    }

    public void zoomTo(double zoomLevel) {
        this.viewer.zoomTo(zoomLevel);
    }

    public void refresh() {
        this.viewer.refresh();
    }

    protected void addDciToRequestList() {
        Collection linkList = this.mapPage.getLinks();
        for (NetworkMapLink item : linkList) {
            if (!item.hasDciData()) continue;
            for (MapDataSource value : item.getDciAsList()) {
                if (value.getType() == 1) {
                    this.dciValueProvider.addDci(value.getNodeId(), value.getDciId(), this.mapPage, 1);
                    continue;
                }
                this.dciValueProvider.addDci(value.getNodeId(), value.getDciId(), value.getColumn(), value.getInstance(), this.mapPage, 1);
            }
        }
        Collection mapElements = this.mapPage.getElements();
        for (NetworkMapElement element : mapElements) {
            NetworkMapDCIContainer item;
            if (element instanceof NetworkMapDCIContainer && (item = (NetworkMapDCIContainer)element).hasDciData()) {
                for (MapDataSource value : item.getObjectDCIArray()) {
                    if (value.getType() == 1) {
                        this.dciValueProvider.addDci(value.getNodeId(), value.getDciId(), this.mapPage, 1);
                        continue;
                    }
                    this.dciValueProvider.addDci(value.getNodeId(), value.getDciId(), value.getColumn(), value.getInstance(), this.mapPage, 1);
                }
            }
            if (!(element instanceof NetworkMapDCIImage)) continue;
            item = (NetworkMapDCIImage)element;
            DCIImageConfiguration config = item.getImageOptions();
            MapImageDataSource value = config.getDci();
            if (value.getType() == 1) {
                this.dciValueProvider.addDci(value.getNodeId(), value.getDciId(), this.mapPage, 1);
                continue;
            }
            this.dciValueProvider.addDci(value.getNodeId(), value.getDciId(), value.getColumn(), value.getInstance(), this.mapPage, 1);
        }
    }

    public MapLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void hideLinkLabels(boolean hide) {
        this.labelProvider.setConnectionLabelsVisible(false);
    }
}

