/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef4.zest.core.widgets.IDecorationFigure;
import org.eclipse.swt.SWT;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ExtendedGraphViewer;

public abstract class DecorationLayerAbstractFigure
extends Figure
implements MouseListener,
MouseMotionListener,
IDecorationFigure {
    private NetworkMapElement decoration;
    private ExtendedGraphViewer viewer;
    private boolean drag = false;
    private boolean selected = false;
    private int lastX;
    private int lastY;

    public DecorationLayerAbstractFigure(NetworkMapElement decoration, ExtendedGraphViewer viewer) {
        this.decoration = decoration;
        this.viewer = viewer;
        this.addMouseListener((MouseListener)this);
    }

    protected abstract void paintFigure(Graphics var1);

    private void stopDragging() {
        this.removeMouseMotionListener((MouseMotionListener)this);
        this.drag = false;
        Point loc = this.getLocation();
        this.decoration.setLocation(loc.x, loc.y);
        this.viewer.onDecorationMove(this.decoration);
        this.viewer.unblockRefresh();
    }

    public void mousePressed(MouseEvent me) {
        if (!this.selected) {
            this.viewer.setDecorationSelection(this.decoration, me.button == 1 && (me.getState() & SWT.MOD1) != 0);
            this.setSelected(true);
        }
        if (me.button == 1 && (me.getState() & SWT.MOD1) == 0) {
            if (this.viewer.isDraggingEnabled()) {
                this.addMouseMotionListener((MouseMotionListener)this);
                this.drag = true;
                this.lastX = me.x;
                this.lastY = me.y;
                this.viewer.blockRefresh();
            }
            me.consume();
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (me.button == 1 && this.drag) {
            this.stopDragging();
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
        if (this.drag) {
            Point p = this.getLocation();
            p.performTranslate(me.x - this.lastX, me.y - this.lastY);
            this.setLocation(p);
            this.lastX = me.x;
            this.lastY = me.y;
            me.consume();
        }
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
        if (this.drag) {
            this.stopDragging();
        }
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public final void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public abstract void refresh();

    protected void notifyElementChanged() {
        this.viewer.onDecorationMove(this.decoration);
    }
}

