/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.TimeFormatter;
import org.netxms.client.maps.LinkDataLocation;
import org.netxms.client.maps.MapDCIInstance;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.client.maps.configs.MapLinkDataSource;
import org.netxms.nxmc.DisposableSingleton;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.tools.FontTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDciValueProvider
implements DisposableSingleton {
    private static Logger logger = LoggerFactory.getLogger(FontTools.class);
    private Set<MapDCIInstance> dciIDList = Collections.synchronizedSet(new HashSet());
    private Map<Long, DciValue> cachedDciValues = new HashMap();
    private NXCSession session = Registry.getSession();
    private Thread syncThread = new Thread(() -> this.syncLastValues(), "LinkDciValueProvider");
    private volatile boolean syncRunning = true;

    public static LinkDciValueProvider getInstance() {
        LinkDciValueProvider instance = (LinkDciValueProvider)Registry.getSingleton(LinkDciValueProvider.class);
        if (instance == null) {
            instance = new LinkDciValueProvider();
            Registry.setSingleton(LinkDciValueProvider.class, (Object)instance);
        }
        return instance;
    }

    public LinkDciValueProvider() {
        this.syncThread.setDaemon(true);
        this.syncThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncLastValues() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.syncRunning) {
            Map map = this.cachedDciValues;
            synchronized (map) {
                Set set = this.dciIDList;
                synchronized (set) {
                    try {
                        if (this.dciIDList.size() > 0) {
                            DciValue[] values;
                            for (DciValue v : values = this.session.getLastValues(this.dciIDList)) {
                                this.cachedDciValues.put(v.getId(), v);
                            }
                        }
                    }
                    catch (Exception e2) {
                        logger.error("Exception in sync last values thread - " + e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.session = null;
        logger.debug("LinkDciValueProvider thread stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DciValue getDciLastValue(long dciID) {
        DciValue value;
        Map map = this.cachedDciValues;
        synchronized (map) {
            value = (DciValue)this.cachedDciValues.get(dciID);
        }
        return value;
    }

    public void dispose() {
        this.syncRunning = false;
        this.syncThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDci(long nodeID, long dciID, NetworkMapPage mapPage, int initialCount) {
        Set set = this.dciIDList;
        synchronized (set) {
            boolean exists = false;
            for (MapDCIInstance item : this.dciIDList) {
                if (item.getDciID() != dciID) continue;
                item.addMap(mapPage.getMapObjectId(), initialCount);
                exists = true;
                break;
            }
            if (!exists) {
                this.dciIDList.add(new MapDCIInstance(dciID, nodeID, 1, mapPage.getMapObjectId(), initialCount));
                this.syncThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDci(long nodeID, long dciID, String column, String instance, NetworkMapPage mapPage, int initialCount) {
        Set set = this.dciIDList;
        synchronized (set) {
            boolean exists = false;
            for (MapDCIInstance item : this.dciIDList) {
                if (item.getDciID() != dciID) continue;
                item.addMap(mapPage.getMapObjectId(), initialCount);
                exists = true;
                break;
            }
            if (!exists) {
                this.dciIDList.add(new MapDCIInstance(dciID, nodeID, column, instance, 2, mapPage.getMapObjectId(), initialCount));
                this.syncThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDcis(NetworkMapPage mapPage) {
        Set set = this.dciIDList;
        synchronized (set) {
            ArrayList<MapDCIInstance> forRemove = new ArrayList<MapDCIInstance>();
            for (MapDCIInstance item : this.dciIDList) {
                if (!item.removeMap(mapPage.getMapObjectId())) continue;
                forRemove.add(item);
            }
            for (MapDCIInstance item : forRemove) {
                this.dciIDList.remove(item);
            }
        }
    }

    public String getDciDataAsString(NetworkMapLink link, LinkDataLocation location) {
        if (!link.hasDciData()) {
            return "";
        }
        MapLinkDataSource[] dciList = link.getDciList();
        TimeFormatter timeFormatter = DateFormatFactory.getTimeFormatter();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dciList.length; ++i) {
            DciValue v;
            if (dciList[i].getLocation() != location) continue;
            if (!sb.isEmpty()) {
                sb.append('\n');
            }
            if ((v = this.getDciLastValue(dciList[i].getDciId())) == null) continue;
            sb.append(v.getFormattedValue(dciList[i].getFormatString(), timeFormatter));
        }
        return sb.toString();
    }

    public String getDciDataAsString(List<MapDataSource> dciList) {
        TimeFormatter timeFormatter = DateFormatFactory.getTimeFormatter();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < dciList.size()) {
            DciValue v = this.getDciLastValue(dciList.get(i).getDciId());
            if (v != null) {
                sb.append(v.getFormattedValue(dciList.get(i).getFormatString(), timeFormatter));
            }
            if (++i == dciList.size()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public List<DciValue> getDciData(List<? extends MapDataSource> dciList) {
        ArrayList<DciValue> result = new ArrayList<DciValue>();
        for (int i = 0; i < dciList.size(); ++i) {
            DciValue value = this.getDciLastValue(dciList.get(i).getDciId());
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public DciValue getLastDciData(MapDataSource dci) {
        return this.getDciLastValue(dci.getDciId());
    }
}

