/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectFigure;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class ObjectFigureSmallLabel
extends ObjectFigure {
    private static final int BORDER_WIDTH = 2;
    private static final int MARGIN_WIDTH = 4;
    private static final int MARGIN_HEIGHT = 2;
    private Label label;

    public ObjectFigureSmallLabel(NetworkMapObject element, MapLabelProvider labelProvider) {
        super(element, labelProvider);
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.label = new Label(this.object.getNameOnMap());
        this.label.setFont(labelProvider.getLabelFont());
        this.label.setLabelAlignment(2);
        this.label.setIcon(labelProvider.getSmallIcon((Object)this.object));
        this.add((IFigure)this.label, (Object)BorderLayout.CENTER);
        this.setOpaque(true);
        this.updateSize();
    }

    private void updateSize() {
        Dimension ls = this.label.getPreferredSize(-1, -1);
        this.setSize(ls.width + 8 + 4, ls.height + 4 + 4);
    }

    protected void paintFigure(Graphics gc) {
        Rectangle rect = new Rectangle(this.getBounds());
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        gc.setAntialias(1);
        if (!this.labelProvider.isTranslucentLabelBackground()) {
            gc.setBackgroundColor(SOLID_WHITE);
            gc.fillRoundRectangle(rect, 8, 8);
        }
        gc.setBackgroundColor(this.isElementSelected() ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        gc.setAlpha(32);
        gc.fillRoundRectangle(rect, 8, 8);
        gc.setAlpha(255);
        gc.setForegroundColor(this.isElementSelected() ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        gc.setLineStyle(this.labelProvider.isElementSelected((NetworkMapElement)this.element) ? 3 : 1);
        gc.setLineWidth(2);
        gc.drawRoundRectangle(rect, 8, 8);
    }
}

