/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.DecorationLayerAbstractFigure;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ExtendedGraphViewer;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.tools.ColorConverter;

public class TextBoxFigure
extends DecorationLayerAbstractFigure {
    private static final int MARGIN_X = 3;
    private static final int MARGIN_Y = 3;
    private static final int BORDER_SIZE = 3;
    private Label text;
    private NetworkMapTextBox textBoxElement;
    private MapLabelProvider labelProvider;

    public TextBoxFigure(NetworkMapTextBox decoration, MapLabelProvider labelProvider, ExtendedGraphViewer viewer) {
        super((NetworkMapElement)decoration, viewer);
        this.textBoxElement = decoration;
        this.labelProvider = labelProvider;
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.text = new Label(this.textBoxElement.getText());
        this.text.setFont(new Font((Device)Display.getCurrent(), "Verdana", this.textBoxElement.getFontSize(), 0));
        this.text.setLabelAlignment(2);
        Dimension d = this.text.getPreferredSize();
        this.text.setSize(d);
        Point p = this.text.getLocation();
        p.translate(12, 3);
        this.text.setLocation(p);
        this.add((IFigure)this.text);
        this.setSize(d.width + 24, d.height + 6);
        this.text.setForegroundColor(labelProvider.getColors().create(ColorConverter.rgbFromInt((int)this.textBoxElement.getTextColor())));
    }

    protected void paintFigure(Graphics gc) {
        gc.setAntialias(1);
        Rectangle rect = new Rectangle(this.getBounds());
        rect.x += 3;
        rect.y += 3;
        rect.width -= 6;
        rect.height -= 6;
        gc.setBackgroundColor(this.labelProvider.getColors().create(ColorConverter.rgbFromInt((int)this.textBoxElement.getBackgroundColor())));
        gc.fillRoundRectangle(rect, 3, 3);
        if (this.textBoxElement.isBorderRequired()) {
            rect = new Rectangle(this.getBounds());
            ++rect.x;
            ++rect.y;
            rect.width -= 3;
            rect.height -= 3;
            gc.setForegroundColor(this.labelProvider.getColors().create(ColorConverter.rgbFromInt((int)this.textBoxElement.getBorderColor())));
            gc.setLineWidth(3);
            gc.setLineStyle(1);
            gc.drawRoundRectangle(rect, 8, 8);
        }
    }

    public void refresh() {
        this.text.setText(this.textBoxElement.getText());
        Dimension d = this.text.getPreferredSize();
        this.text.setSize(d);
        Point p = this.text.getLocation();
        p.translate(12, 3);
        this.text.setLocation(p);
        this.setSize(d.width + 24, d.height + 6);
        this.repaint();
    }
}

