/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import org.netxms.client.NXCSession;
import org.netxms.nxmc.PreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceTimePeriods {
    private static Logger logger = LoggerFactory.getLogger(MaintenanceTimePeriods.class);

    public static void init(NXCSession session) {
        String line = session.getObjectMaintenancePredefinedPeriods();
        String[] entries = line.split(",");
        PreferenceStore ps = PreferenceStore.getInstance();
        for (String entrySrc : entries) {
            String entry = entrySrc.trim();
            int multiplier = 1;
            if (entry.toUpperCase().endsWith("M")) {
                multiplier = 60;
            } else if (entry.toUpperCase().endsWith("H")) {
                multiplier = 3600;
            } else if (entry.toUpperCase().endsWith("D")) {
                multiplier = 86400;
            }
            if (multiplier != 1) {
                entry = entry.substring(0, entry.length() - 1);
            }
            try {
                int time = Integer.parseInt(entry) * multiplier;
                int menuSize = ps.getAsInteger("Maintenance.TimeMenuSize", 0);
                boolean found = false;
                for (int i = 0; i < menuSize; ++i) {
                    int currEntryTime = ps.getAsInteger("Maintenance.TimeMenuEntry." + Integer.toString(i), 0);
                    if (time != currEntryTime) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ps.set("Maintenance.TimeMenuEntry." + menuSize, time);
                ps.set("Maintenance.TimeMenuSize", ++menuSize);
            }
            catch (Exception e) {
                logger.error(String.format("Error parsing time period defenition \"%s\"", entrySrc));
            }
        }
    }
}

