/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.MacAddress;
import org.netxms.base.MacAddressFormatException;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MacAddressValidator;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditMacAddressDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(EditMacAddressDialog.class);
    private LabeledText macAddrField;
    private MacAddress macAddress;

    public EditMacAddressDialog(Shell newShell, MacAddress macAddress) {
        super(newShell);
        newShell.setText(this.i18n.tr("Edit MAC Address"));
        this.macAddress = macAddress;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.macAddrField = new LabeledText(dialogArea, 0);
        this.macAddrField.setLabel(this.i18n.tr("MAC address"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.macAddrField.setLayoutData((Object)gd);
        this.macAddrField.getTextControl().setText(this.macAddress != null ? this.macAddress.toString() : "");
        return dialogArea;
    }

    protected void okPressed() {
        if (!WidgetHelper.validateTextInput((LabeledText)this.macAddrField, (TextFieldValidator)new MacAddressValidator(true))) {
            WidgetHelper.adjustWindowSize((Window)this);
            return;
        }
        try {
            this.macAddress = this.macAddrField.getText().trim().isEmpty() ? new MacAddress() : MacAddress.parseMacAddress((String)this.macAddrField.getText());
            super.okPressed();
        }
        catch (MacAddressFormatException e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)String.format(this.i18n.tr("Failed to parse MAC: %s"), e.getLocalizedMessage()));
            WidgetHelper.adjustWindowSize((Window)this);
        }
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }
}

