/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.EffectiveRightsDialog;
import org.netxms.nxmc.modules.users.widgets.UserSelector;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EffectiveRightsDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(EffectiveRightsDialog.class);
    private AbstractObject object;
    private NXCSession session;
    private boolean canSelectUser;
    private UserSelector userSelector;
    private Table rightsTable;
    private List<RightDefinition> rightDefinitions;
    private int currentEffectiveRights = 0;
    private Image checkImage;
    private Image uncheckImage;

    public EffectiveRightsDialog(Shell parentShell, AbstractObject object) {
        super(parentShell);
        this.object = object;
        this.session = Registry.getSession();
        this.canSelectUser = (object.getEffectiveRights() & 0x20) != 0;
        this.initRightDefinitions();
        this.checkImage = ResourceManager.getImage((String)"icons/active.png");
        this.uncheckImage = ResourceManager.getImage((String)"icons/inactive.png");
        parentShell.addDisposeListener((DisposeListener & Serializable)e -> {
            this.checkImage.dispose();
            this.uncheckImage.dispose();
        });
    }

    private void initRightDefinitions() {
        this.rightDefinitions = new ArrayList();
        this.rightDefinitions.add(new RightDefinition(1, this.i18n.tr("Read")));
        this.rightDefinitions.add(new RightDefinition(65536, this.i18n.tr("Read agent data")));
        this.rightDefinitions.add(new RightDefinition(131072, this.i18n.tr("Read SNMP data")));
        this.rightDefinitions.add(new RightDefinition(2, this.i18n.tr("Modify")));
        this.rightDefinitions.add(new RightDefinition(0x200000, this.i18n.tr("Edit comments")));
        this.rightDefinitions.add(new RightDefinition(0x400000, this.i18n.tr("Manage responsible users")));
        this.rightDefinitions.add(new RightDefinition(4, this.i18n.tr("Create child objects")));
        this.rightDefinitions.add(new RightDefinition(0x800000, this.i18n.tr("Delegated read")));
        this.rightDefinitions.add(new RightDefinition(8, this.i18n.tr("Delete")));
        this.rightDefinitions.add(new RightDefinition(256, this.i18n.tr("Control")));
        this.rightDefinitions.add(new RightDefinition(128, this.i18n.tr("Send events")));
        this.rightDefinitions.add(new RightDefinition(16, this.i18n.tr("View alarms")));
        this.rightDefinitions.add(new RightDefinition(64, this.i18n.tr("Update alarms")));
        this.rightDefinitions.add(new RightDefinition(512, this.i18n.tr("Terminate alarms")));
        this.rightDefinitions.add(new RightDefinition(2048, this.i18n.tr("Create helpdesk tickets")));
        this.rightDefinitions.add(new RightDefinition(1024, this.i18n.tr("Push data")));
        this.rightDefinitions.add(new RightDefinition(32, this.i18n.tr("Access control")));
        this.rightDefinitions.add(new RightDefinition(4096, this.i18n.tr("Download files")));
        this.rightDefinitions.add(new RightDefinition(8192, this.i18n.tr("Upload files")));
        this.rightDefinitions.add(new RightDefinition(16384, this.i18n.tr("Manage files")));
        this.rightDefinitions.add(new RightDefinition(0x100000, this.i18n.tr("Configure agent")));
        this.rightDefinitions.add(new RightDefinition(262144, this.i18n.tr("Take screenshot")));
        this.rightDefinitions.add(new RightDefinition(32768, this.i18n.tr("Control maintenance mode")));
        this.rightDefinitions.add(new RightDefinition(524288, this.i18n.tr("Edit maintenance journal")));
        this.rightDefinitions.add(new RightDefinition(0x1000000, this.i18n.tr("Manage policies")));
        this.rightDefinitions.add(new RightDefinition(0x2000000, this.i18n.tr("Manage incidents")));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Effective Rights"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.i18n.tr("Close"), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        LabeledText objectNameField = new LabeledText(dialogArea, 0);
        objectNameField.setLabel(this.i18n.tr("Object"));
        objectNameField.setText(this.object.getObjectName());
        objectNameField.setEditable(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        objectNameField.setLayoutData((Object)gd);
        this.userSelector = new UserSelector(dialogArea, 0);
        this.userSelector.setLabel(this.i18n.tr("Select user"));
        this.userSelector.setUserId(this.session.getUserId());
        this.userSelector.setEnabled(this.canSelectUser);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.userSelector.setLayoutData((Object)gd);
        this.userSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.canSelectUser) {
            Label hint = new Label(dialogArea, 0);
            hint.setText(this.i18n.tr("(You need Access Control permission to view other users' rights)"));
            hint.setForeground(parent.getDisplay().getSystemColor(16));
        }
        Label tableLabel = new Label(dialogArea, 0);
        tableLabel.setText(this.i18n.tr("Effective Access Rights:"));
        this.rightsTable = new Table(dialogArea, 67584);
        this.rightsTable.setHeaderVisible(false);
        this.rightsTable.setLinesVisible(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.rightsTable.setLayoutData((Object)gd);
        TableColumn colStatus = new TableColumn(this.rightsTable, 0x1000000);
        colStatus.setWidth(24);
        TableColumn colLabel = new TableColumn(this.rightsTable, 16384);
        colLabel.setWidth(350);
        for (RightDefinition rd : this.rightDefinitions) {
            TableItem item = new TableItem(this.rightsTable, 0);
            item.setText(1, rd.label);
            item.setData((Object)rd);
        }
        this.refreshEffectiveRights();
        return dialogArea;
    }

    private void refreshEffectiveRights() {
        int userId = this.userSelector.getUserId();
        if (userId == 0) {
            return;
        }
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void updateRightsDisplay() {
        for (TableItem item : this.rightsTable.getItems()) {
            RightDefinition rd = (RightDefinition)item.getData();
            boolean granted = (this.currentEffectiveRights & rd.mask) != 0;
            item.setImage(0, granted ? this.checkImage : this.uncheckImage);
            item.setForeground(1, granted ? null : WidgetHelper.getSystemColor((int)39));
        }
    }
}

