/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.InputField;
import org.netxms.nxmc.base.widgets.LabeledControl;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.modules.objects.dialogs.InputFieldEntryDialog;

public class InputFieldEntryDialog
extends Dialog {
    private String title;
    private InputField[] fields;
    private LabeledControl[] controls;
    private Map<String, String> values = null;

    public static Map<String, String> readInputFields(Shell parentShell, String title, InputField[] fields) {
        InputFieldEntryDialog dlg = new InputFieldEntryDialog(parentShell, title, fields);
        if (dlg.open() != 0) {
            return null;
        }
        return dlg.getValues();
    }

    public InputFieldEntryDialog(Shell parentShell, String title, InputField[] fields) {
        super(parentShell);
        this.title = title;
        this.fields = fields;
        this.controls = new LabeledControl[fields.length];
    }

    public InputFieldEntryDialog(Shell parentShell, String title, InputField[] fields, Map<String, String> inputValues) {
        super(parentShell);
        this.title = title;
        this.fields = fields;
        this.controls = new LabeledControl[inputValues.size()];
        this.values = inputValues;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        for (int i = 0; i < this.fields.length; ++i) {
            LabeledSpinner c = switch (1.$SwitchMap$org$netxms$client$constants$InputFieldType[this.fields[i].getType().ordinal()]) {
                case 1 -> new LabeledSpinner(dialogArea, 0);
                case 2 -> new LabeledText(dialogArea, 0, 0x400800, 300);
                default -> new LabeledText(dialogArea, 0, 2048, 300);
            };
            c.setLabel(this.fields[i].getDisplayName());
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            c.setLayoutData((Object)gd);
            if (this.values != null && this.values.containsKey(this.fields[i].getName())) {
                c.setText((String)this.values.get(this.fields[i].getName()));
            }
            this.controls[i] = c;
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.values = new HashMap();
        for (int i = 0; i < this.fields.length; ++i) {
            this.values.put(this.fields[i].getName(), this.controls[i].getText());
        }
        super.okPressed();
    }

    public Map<String, String> getValues() {
        return this.values;
    }
}

