/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class TemplateDeleteDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(TemplateDeleteDialog.class);
    private String objectName;
    private boolean isCluster;
    private boolean removeDci;
    private Button radioRemove;
    private Button radioUnbind;

    public TemplateDeleteDialog(Shell parentShell, String templateName) {
        this(parentShell, templateName, false);
    }

    public TemplateDeleteDialog(Shell parentShell, String objectName, boolean isCluster) {
        super(parentShell);
        this.objectName = objectName;
        this.isCluster = isCluster;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.isCluster ? this.i18n.tr("Delete Cluster") : this.i18n.tr("Delete Template"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite controls = new Composite(dialogArea, 0);
        controls.setLayout((Layout)new GridLayout());
        controls.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(controls, 64);
        if (this.isCluster) {
            label.setText(String.format(this.i18n.tr("You are about to delete cluster \"%s\". Please select how to handle DCIs created from this cluster on all member nodes:"), this.objectName));
        } else {
            label.setText(String.format(this.i18n.tr("You are about to delete template \"%s\". Please select how to handle DCIs created from this template on all bound objects:"), this.objectName));
        }
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 400;
        label.setLayoutData((Object)gd);
        this.radioRemove = new Button(controls, 16);
        this.radioRemove.setText(this.isCluster ? this.i18n.tr("&Remove DCIs from all member nodes") : this.i18n.tr("&Remove DCIs from all objects"));
        this.radioRemove.setSelection(true);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.radioRemove.setLayoutData((Object)gd);
        this.radioUnbind = new Button(controls, 16);
        this.radioUnbind.setText(this.isCluster ? this.i18n.tr("&Unbind DCIs from cluster (keep as standalone)") : this.i18n.tr("&Unbind DCIs from template (keep as standalone)"));
        this.radioUnbind.setSelection(false);
        gd = new GridData();
        gd.horizontalIndent = 10;
        this.radioUnbind.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.removeDci = this.radioRemove.getSelection();
        super.okPressed();
    }

    public boolean isRemoveDci() {
        return this.removeDci;
    }
}

