/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.GeoArea;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.GeoLocationControlMode;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Sensor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.LocationControl;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class LocationControl
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(LocationControl.class);
    private DataCollectionTarget dcTarget;
    private Set<Integer> geoAreas = new HashSet();
    private Map<Integer, GeoArea> geoAreaCache = new HashMap();
    private Button checkGenerateEvent;
    private Combo locationControlMode;
    private TableViewer areaListViewer;
    private Button addButton;
    private Button deleteButton;
    private boolean initialGenerateEventSelection;
    private GeoLocationControlMode initialLocationControlMode;
    private boolean isAreaListModified = false;

    public LocationControl(AbstractObject object) {
        super(LocalizationHelper.getI18n(LocationControl.class).tr("Location Control"), object);
    }

    public String getId() {
        return "locationControl";
    }

    public String getParentId() {
        return "location";
    }

    public boolean isVisible() {
        return this.object instanceof AbstractNode || this.object instanceof MobileDevice || this.object instanceof Sensor;
    }

    protected Control createContents(Composite parent) {
        this.dcTarget = (DataCollectionTarget)this.object;
        this.initialGenerateEventSelection = this.dcTarget.isLocationChageEventGenerated();
        this.initialLocationControlMode = this.dcTarget.getGeoLocationControlMode();
        for (long id : this.dcTarget.getGeoAreas()) {
            this.geoAreas.add((int)id);
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        dialogArea.setLayout((Layout)layout);
        this.checkGenerateEvent = new Button(dialogArea, 32);
        this.checkGenerateEvent.setText("&Generate event when location changes");
        this.checkGenerateEvent.setSelection(this.dcTarget.isLocationChageEventGenerated());
        this.checkGenerateEvent.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.locationControlMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)"Location control mode", (Object)"WidgetHelper::default_layout_data");
        this.locationControlMode.add("No control");
        this.locationControlMode.add("Alert when within restricted area");
        this.locationControlMode.add("Alert when outside allowed area");
        this.locationControlMode.select(this.dcTarget.getGeoLocationControlMode().getValue());
        Composite viewerComposite = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        viewerComposite.setLayout((Layout)layout);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(viewerComposite, 16384).setText("Areas");
        this.areaListViewer = new TableViewer(viewerComposite, 2048);
        this.areaListViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.areaListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.areaListViewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.areaListViewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.areaListViewer.setInput((Object)this.geoAreas);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("Add..."));
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("Delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        NXCSession session = Registry.getSession();
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.checkGenerateEvent.getSelection() == this.initialGenerateEventSelection && GeoLocationControlMode.getByValue((int)this.locationControlMode.getSelectionIndex()) == this.initialLocationControlMode && !this.isAreaListModified) {
            return true;
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setGeoLocationControlMode(GeoLocationControlMode.getByValue((int)this.locationControlMode.getSelectionIndex()));
        md.setObjectFlags(this.checkGenerateEvent.getSelection() ? 8L : 0L, 8L);
        long[] areas = new long[this.geoAreas.size()];
        int index = 0;
        for (Integer id : this.geoAreas) {
            areas[index++] = id.intValue();
        }
        md.setGeoAreas(areas);
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkGenerateEvent.setSelection(false);
        this.locationControlMode.select(GeoLocationControlMode.NO_CONTROL.getValue());
        if (!this.geoAreas.isEmpty()) {
            this.geoAreas.clear();
            this.areaListViewer.refresh();
            this.isAreaListModified = true;
        }
    }
}

