/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.SshKeyPair;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.PasswordInputField;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectSelectionFilterFactory;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.SSH;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SSH
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(SSH.class);
    private AbstractNode node;
    private ObjectSelector sshProxy;
    private LabeledText sshLogin;
    private PasswordInputField sshPassword;
    private LabeledText sshPort;
    private Combo sshKey;
    private List<SshKeyPair> keyList;
    private NXCSession session;

    public SSH(AbstractObject object) {
        super(LocalizationHelper.getI18n(SSH.class).tr("SSH"), object);
    }

    public String getId() {
        return "communication.ssh";
    }

    public String getParentId() {
        return "communication";
    }

    public boolean isVisible() {
        return this.object instanceof AbstractNode;
    }

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.object;
        this.session = Registry.getSession();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.numColumns = 2;
        dialogLayout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)dialogLayout);
        this.sshLogin = new LabeledText(dialogArea, 0);
        this.sshLogin.setLabel(this.i18n.tr("Login"));
        this.sshLogin.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshLogin.setText(this.node.getSshLogin());
        this.sshPassword = new PasswordInputField(dialogArea, 0);
        this.sshPassword.setLabel(this.i18n.tr("Password"));
        this.sshPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshPassword.setText(this.node.getSshPassword());
        this.sshPort = new LabeledText(dialogArea, 0);
        this.sshPort.setLabel(this.i18n.tr("Port"));
        this.sshPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshPort.setText(Integer.toString(this.node.getSshPort()));
        this.sshKey = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)this.i18n.tr("Key"), (Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sshProxy = new ObjectSelector(dialogArea, 0, true);
        this.sshProxy.setLabel(this.i18n.tr("Proxy"));
        this.sshProxy.setEmptySelectionName(this.i18n.tr("<default>"));
        this.sshProxy.setClassFilter(ObjectSelectionFilterFactory.getInstance().createNodeSelectionFilter(false));
        this.sshProxy.setObjectId(this.node.getSshProxyId());
        this.sshProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.loadSshKeyList();
        return dialogArea;
    }

    private void loadSshKeyList() {
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        try {
            md.setSshPort(Integer.parseInt(this.sshPort.getText(), 10));
        }
        catch (NumberFormatException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid SSH port number"));
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        int selection = this.sshKey.getSelectionIndex();
        if (selection > 0) {
            SshKeyPair d = (SshKeyPair)this.keyList.get(selection - 1);
            md.setSshKeyId(d.getId());
        } else {
            md.setSshKeyId(0);
        }
        md.setSshProxy(this.sshProxy.getObjectId());
        md.setSshLogin(this.sshLogin.getText().trim());
        md.setSshPassword(this.sshPassword.getText());
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.sshProxy.setObjectId(0L);
        this.sshLogin.setText("netxms");
        this.sshPassword.setText("");
        this.sshPort.setText("22");
    }
}

