/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.Locale;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.MacAddress;
import org.netxms.base.MacAddressFormatException;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.SensorDeviceClass;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Sensor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SensorProperties
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(SensorProperties.class);
    private Sensor sensor;
    private LabeledCombo deviceClass;
    private ObjectSelector gatewayNode;
    private LabeledText macAddress;
    private LabeledText deviceAddress;
    private LabeledSpinner modbusUnitId;
    private LabeledText vendor;
    private LabeledText model;
    private LabeledText serialNumber;

    public SensorProperties(AbstractObject object) {
        super(LocalizationHelper.getI18n(SensorProperties.class).tr("Sensor"), object);
    }

    public String getId() {
        return "sensorProperties";
    }

    public int getPriority() {
        return 1;
    }

    public boolean isVisible() {
        return this.object instanceof Sensor;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.sensor = (Sensor)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.deviceClass = new LabeledCombo(dialogArea, 0);
        this.deviceClass.setLabel(this.i18n.tr("Device class"));
        this.deviceClass.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Locale locale = LocalizationHelper.getLocale();
        for (SensorDeviceClass c : (SensorDeviceClass[])SensorDeviceClass.class.getEnumConstants()) {
            this.deviceClass.add(c.getDisplayName(locale));
        }
        this.deviceClass.select(this.sensor.getDeviceClass().getValue());
        this.gatewayNode = new ObjectSelector(dialogArea, 0, true);
        this.gatewayNode.setLabel(this.i18n.tr("Gateway node"));
        this.gatewayNode.setObjectClass(Node.class);
        this.gatewayNode.setClassFilter(ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        this.gatewayNode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.gatewayNode.setObjectId(this.sensor.getGatewayId());
        this.macAddress = new LabeledText(dialogArea, 0);
        this.macAddress.setLabel(this.i18n.tr("MAC address"));
        this.macAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.macAddress.setText(this.sensor.getMacAddress().toString());
        this.modbusUnitId = new LabeledSpinner(dialogArea, 0);
        this.modbusUnitId.setLabel(this.i18n.tr("Modbus unit ID"));
        this.modbusUnitId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.modbusUnitId.setRange(0, 255);
        this.modbusUnitId.setSelection((int)this.sensor.getModbusUnitId());
        this.deviceAddress = new LabeledText(dialogArea, 0);
        this.deviceAddress.setLabel(this.i18n.tr("Device address"));
        this.deviceAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.deviceAddress.setText(this.sensor.getDeviceAddress());
        this.vendor = new LabeledText(dialogArea, 0);
        this.vendor.setLabel(this.i18n.tr("Vendor"));
        this.vendor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.vendor.setText(this.sensor.getVendor());
        this.model = new LabeledText(dialogArea, 0);
        this.model.setLabel(this.i18n.tr("Model"));
        this.model.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.model.setText(this.sensor.getModel());
        this.serialNumber = new LabeledText(dialogArea, 0);
        this.serialNumber.setLabel(this.i18n.tr("Serial number"));
        this.serialNumber.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.serialNumber.setText(this.sensor.getSerialNumber());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.sensor.getObjectId());
        String macAddressText = this.macAddress.getText().trim();
        if (!macAddressText.isEmpty()) {
            try {
                md.setMacAddress(MacAddress.parseMacAddress((String)this.macAddress.getText().trim()));
            }
            catch (MacAddressFormatException e) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Invalid MAC address"));
                return false;
            }
        } else {
            md.setMacAddress(new MacAddress());
        }
        md.setDeviceClass(SensorDeviceClass.getByValue((int)this.deviceClass.getSelectionIndex()));
        md.setVendor(this.vendor.getText().trim());
        md.setModel(this.model.getText().trim());
        md.setSerialNumber(this.serialNumber.getText().trim());
        md.setDeviceAddress(this.deviceAddress.getText().trim());
        md.setModbusUnitId(Short.valueOf((short)this.modbusUnitId.getSelection()));
        md.setSensorProxy(this.gatewayNode.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        this.gatewayNode.setObjectId(0L);
        this.deviceClass.select(0);
        this.macAddress.setText("");
        this.deviceAddress.setText("");
        this.modbusUnitId.setSelection(255);
        this.vendor.setText("");
        this.model.setText("");
        this.serialNumber.setText("");
    }
}

