/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.Arrays;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.client.objects.AssetGroup;
import org.netxms.client.objects.AssetRoot;
import org.netxms.client.objects.DashboardBase;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.NumericTextFieldValidator;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class StatusCalculation
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(StatusCalculation.class);
    private NXCObjectModificationData currentState;
    private int calculationMethod;
    private int propagationMethod;
    private Button radioCalcDefault;
    private Button radioCalcMostCritical;
    private Button radioCalcSingle;
    private Button radioCalcMultiple;
    private Button radioPropDefault;
    private Button radioPropUnchanged;
    private Button radioPropFixed;
    private Button radioPropRelative;
    private Button radioPropTranslated;
    private Combo comboFixedStatus;
    private Combo[] comboTranslatedStatus = new Combo[4];
    private Text textRelativeStatus;
    private Text textSingleThreshold;
    private Text[] textThresholds = new Text[4];

    public StatusCalculation(AbstractObject object) {
        super(LocalizationHelper.getI18n(StatusCalculation.class).tr("Status Calculation"), object);
    }

    public String getId() {
        return "statusCalculation";
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.currentState = new NXCObjectModificationData(this.object.getObjectId());
        this.currentState.setStatusCalculationMethod(this.object.getStatusCalculationMethod());
        this.currentState.setStatusPropagationMethod(this.object.getStatusPropagationMethod());
        this.currentState.setFixedPropagatedStatus(this.object.getFixedPropagatedStatus());
        this.currentState.setStatusShift(this.object.getStatusShift());
        this.currentState.setStatusTransformation(this.object.getStatusTransformation());
        this.currentState.setStatusSingleThreshold(this.object.getStatusSingleThreshold());
        this.currentState.setStatusThresholds(this.object.getStatusThresholds());
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.createLeftPanel(dialogArea);
        this.createRightPanel(dialogArea);
        this.changeCalculationMethod(this.object.getStatusCalculationMethod());
        this.changePropagationMethod(this.object.getStatusPropagationMethod());
        this.createCalcSelectionListener(this.radioCalcDefault, 0);
        this.createCalcSelectionListener(this.radioCalcMostCritical, 1);
        this.createCalcSelectionListener(this.radioCalcSingle, 2);
        this.createCalcSelectionListener(this.radioCalcMultiple, 3);
        this.createPropSelectionListener(this.radioPropDefault, 0);
        this.createPropSelectionListener(this.radioPropUnchanged, 1);
        this.createPropSelectionListener(this.radioPropFixed, 2);
        this.createPropSelectionListener(this.radioPropRelative, 3);
        this.createPropSelectionListener(this.radioPropTranslated, 4);
        return dialogArea;
    }

    private void createLeftPanel(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.i18n.tr("Propagate status as"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.radioPropDefault = new Button((Composite)group, 16);
        this.radioPropDefault.setText(this.i18n.tr("&Default"));
        this.radioPropDefault.setSelection(this.object.getStatusPropagationMethod() == 0);
        this.radioPropUnchanged = new Button((Composite)group, 16);
        this.radioPropUnchanged.setText(this.i18n.tr("&Unchanged"));
        this.radioPropUnchanged.setSelection(this.object.getStatusPropagationMethod() == 1);
        this.radioPropFixed = new Button((Composite)group, 16);
        this.radioPropFixed.setText(this.i18n.tr("&Fixed to value:"));
        this.radioPropFixed.setSelection(this.object.getStatusPropagationMethod() == 2);
        this.comboFixedStatus = new Combo((Composite)group, 2056);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.comboFixedStatus.setLayoutData((Object)gd);
        for (int i = 0; i < 5; ++i) {
            this.comboFixedStatus.add(StatusDisplayInfo.getStatusText((int)i));
        }
        this.comboFixedStatus.select(this.object.getFixedPropagatedStatus().getValue());
        this.radioPropRelative = new Button((Composite)group, 16);
        this.radioPropRelative.setText(this.i18n.tr("&Relative with offset:"));
        this.radioPropRelative.setSelection(this.object.getStatusPropagationMethod() == 3);
        this.textRelativeStatus = new Text((Composite)group, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.textRelativeStatus.setLayoutData((Object)gd);
        this.textRelativeStatus.setText(Integer.toString(this.object.getStatusShift()));
        this.radioPropTranslated = new Button((Composite)group, 16);
        this.radioPropTranslated.setText(this.i18n.tr("&Severity based:"));
        this.radioPropTranslated.setSelection(this.object.getStatusPropagationMethod() == 4);
        Composite translationGroup = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        translationGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        translationGroup.setLayoutData((Object)gd);
        for (int i = 0; i < 4; ++i) {
            Label label = new Label(translationGroup, 0);
            label.setText(StatusDisplayInfo.getStatusText((int)(i + 1)));
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            label.setLayoutData((Object)gd);
            label = new Label(translationGroup, 0);
            label.setText("->");
            gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            label.setLayoutData((Object)gd);
            this.comboTranslatedStatus[i] = new Combo(translationGroup, 2056);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.comboTranslatedStatus[i].setLayoutData((Object)gd);
            for (int j = 0; j < 5; ++j) {
                this.comboTranslatedStatus[i].add(StatusDisplayInfo.getStatusText((int)j));
            }
            this.comboTranslatedStatus[i].select(this.object.getStatusTransformation()[i].getValue());
        }
    }

    private void createRightPanel(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.i18n.tr("Calculate status as"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.radioCalcDefault = new Button((Composite)group, 16);
        this.radioCalcDefault.setText(this.i18n.tr("D&efault"));
        this.radioCalcDefault.setSelection(this.object.getStatusCalculationMethod() == 0);
        this.radioCalcMostCritical = new Button((Composite)group, 16);
        this.radioCalcMostCritical.setText(this.i18n.tr("&Most critical"));
        this.radioCalcMostCritical.setSelection(this.object.getStatusCalculationMethod() == 1);
        this.radioCalcSingle = new Button((Composite)group, 16);
        this.radioCalcSingle.setText(this.i18n.tr("&Single threshold (%):"));
        this.radioCalcSingle.setSelection(this.object.getStatusCalculationMethod() == 2);
        this.textSingleThreshold = new Text((Composite)group, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.textSingleThreshold.setLayoutData((Object)gd);
        this.textSingleThreshold.setText(Integer.toString(this.object.getStatusSingleThreshold()));
        this.radioCalcMultiple = new Button((Composite)group, 16);
        this.radioCalcMultiple.setText(this.i18n.tr("M&ultiple thresholds (%):"));
        this.radioCalcMultiple.setSelection(this.object.getStatusCalculationMethod() == 3);
        Composite thresholdGroup = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        thresholdGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        thresholdGroup.setLayoutData((Object)gd);
        for (int i = 0; i < 4; ++i) {
            Label label = new Label(thresholdGroup, 0);
            label.setText(StatusDisplayInfo.getStatusText((int)(i + 1)));
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            label.setLayoutData((Object)gd);
            this.textThresholds[i] = new Text(thresholdGroup, 2048);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.textThresholds[i].setLayoutData((Object)gd);
            this.textThresholds[i].setText(Integer.toString(this.object.getStatusThresholds()[i]));
        }
    }

    private void changeCalculationMethod(int method) {
        this.calculationMethod = method;
        this.textSingleThreshold.setEnabled(method == 2);
        for (int i = 0; i < 4; ++i) {
            this.textThresholds[i].setEnabled(method == 3);
        }
    }

    private void changePropagationMethod(int method) {
        this.propagationMethod = method;
        this.comboFixedStatus.setEnabled(method == 2);
        this.textRelativeStatus.setEnabled(method == 3);
        for (int i = 0; i < 4; ++i) {
            this.comboTranslatedStatus[i].setEnabled(method == 4);
        }
    }

    private void createCalcSelectionListener(Button button, int newMethod) {
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createPropSelectionListener(Button button, int newMethod) {
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.radioCalcDefault.setSelection(true);
        this.radioCalcMostCritical.setSelection(false);
        this.radioCalcMultiple.setSelection(false);
        this.radioCalcSingle.setSelection(false);
        this.radioPropDefault.setSelection(true);
        this.radioPropFixed.setSelection(false);
        this.radioPropRelative.setSelection(false);
        this.radioPropTranslated.setSelection(false);
        this.radioPropUnchanged.setSelection(false);
        this.changeCalculationMethod(0);
        this.changePropagationMethod(0);
    }

    private boolean hasChanges(NXCObjectModificationData md) {
        if (this.currentState.getStatusCalculationMethod() != md.getStatusCalculationMethod() || this.currentState.getStatusPropagationMethod() != md.getStatusPropagationMethod()) {
            return true;
        }
        switch (md.getStatusCalculationMethod()) {
            case 2: {
                if (this.currentState.getStatusSingleThreshold() == md.getStatusSingleThreshold()) break;
                return true;
            }
            case 3: {
                if (Arrays.equals(this.currentState.getStatusThresholds(), md.getStatusThresholds())) break;
                return true;
            }
        }
        switch (md.getStatusPropagationMethod()) {
            case 2: {
                if (this.currentState.getFixedPropagatedStatus() == md.getFixedPropagatedStatus()) break;
                return true;
            }
            case 3: {
                if (this.currentState.getStatusShift() == md.getStatusShift()) break;
                return true;
            }
            case 4: {
                if (Arrays.equals(this.currentState.getStatusTransformation(), md.getStatusTransformation())) break;
                return true;
            }
        }
        return false;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!(WidgetHelper.validateTextInput((Text)this.textRelativeStatus, (TextFieldValidator)new NumericTextFieldValidator(-4L, 4L)) && WidgetHelper.validateTextInput((Text)this.textSingleThreshold, (TextFieldValidator)new NumericTextFieldValidator(0L, 100L)) && WidgetHelper.validateTextInput((Text)this.textThresholds[0], (TextFieldValidator)new NumericTextFieldValidator(0L, 100L)) && WidgetHelper.validateTextInput((Text)this.textThresholds[1], (TextFieldValidator)new NumericTextFieldValidator(0L, 100L)) && WidgetHelper.validateTextInput((Text)this.textThresholds[2], (TextFieldValidator)new NumericTextFieldValidator(0L, 100L)) && WidgetHelper.validateTextInput((Text)this.textThresholds[3], (TextFieldValidator)new NumericTextFieldValidator(0L, 100L)))) {
            WidgetHelper.adjustWindowSize((PreferencePage)this);
            return false;
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setStatusCalculationMethod(this.calculationMethod);
        md.setStatusPropagationMethod(this.propagationMethod);
        md.setFixedPropagatedStatus(ObjectStatus.getByValue((int)this.comboFixedStatus.getSelectionIndex()));
        md.setStatusShift(Integer.parseInt(this.textRelativeStatus.getText()));
        ObjectStatus[] transformations = new ObjectStatus[4];
        for (int i = 0; i < 4; ++i) {
            transformations[i] = ObjectStatus.getByValue((int)this.comboTranslatedStatus[i].getSelectionIndex());
        }
        md.setStatusTransformation(transformations);
        md.setStatusSingleThreshold(Integer.parseInt(this.textSingleThreshold.getText()));
        int[] thresholds = new int[4];
        for (int i = 0; i < 4; ++i) {
            thresholds[i] = Integer.parseInt(this.textThresholds[i].getText());
        }
        md.setStatusThresholds(thresholds);
        if (!this.hasChanges(md)) {
            return true;
        }
        this.currentState = md;
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    public boolean isVisible() {
        return !(this.object instanceof Asset) && !(this.object instanceof AssetGroup) && !(this.object instanceof AssetRoot) && !(this.object instanceof DashboardBase) && !(this.object instanceof DashboardGroup) && !(this.object instanceof DashboardRoot) && !(this.object instanceof Template) && !(this.object instanceof TemplateGroup) && !(this.object instanceof TemplateRoot);
    }
}

