/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.DeviceViewWidget;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;

public class DeviceView
extends ObjectView {
    private ScrolledComposite scroller;
    private DeviceViewWidget deviceView;

    public DeviceView() {
        super(LocalizationHelper.getI18n(DeviceView.class).tr("Device"), ResourceManager.getImageDescriptor((String)"icons/object-views/device.png"), "objects.device-view", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).hasDeviceViewData();
    }

    public int getPriority() {
        return 88;
    }

    protected void onObjectChange(AbstractObject object) {
        this.deviceView.setNodeId(object != null ? object.getObjectId() : 0L);
        this.scroller.setMinSize(this.deviceView.computeSize(-1, -1));
    }

    protected void createContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 768);
        this.deviceView = new DeviceViewWidget((Composite)this.scroller, 0, (View)this);
        this.deviceView.setSizeChangeListener(() -> this.scroller.setMinSize(this.deviceView.computeSize(-1, -1)));
        this.scroller.setBackground(this.deviceView.getBackground());
        this.scroller.setContent((Control)this.deviceView);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refresh() {
        this.deviceView.refresh();
    }
}

