/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.topology.RadioInterface;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectTableView;
import org.netxms.nxmc.modules.objects.views.helpers.RadioInterfaceAPComparator;
import org.netxms.nxmc.modules.objects.views.helpers.RadioInterfaceAPLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class RadioInterfacesAP
extends NodeSubObjectTableView {
    private final I18n i18n = LocalizationHelper.getI18n(RadioInterfacesAP.class);
    public static final int COLUMN_INDEX = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_SSID = 2;
    public static final int COLUMN_BSSID = 3;
    public static final int COLUMN_NIC_VENDOR = 4;
    public static final int COLUMN_BAND = 5;
    public static final int COLUMN_CHANNEL = 6;
    public static final int COLUMN_FREQUENCY = 7;
    public static final int COLUMN_TX_POWER_DBM = 8;
    public static final int COLUMN_TX_POWER_MW = 9;

    public RadioInterfacesAP() {
        super(LocalizationHelper.getI18n(RadioInterfacesAP.class).tr("Radios"), ResourceManager.getImageDescriptor((String)"icons/object-views/radio_interfaces.png"), "objects.ap-radios", false);
    }

    public int getPriority() {
        return 53;
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof AbstractNode && ((AbstractNode)context).isWirelessAccessPoint() || context instanceof AccessPoint);
    }

    protected void createViewer() {
        String[] names = new String[]{this.i18n.tr("Index"), this.i18n.tr("Name"), this.i18n.tr("SSID"), this.i18n.tr("BSSID"), this.i18n.tr("NIC vendor"), this.i18n.tr("Band"), this.i18n.tr("Channel"), this.i18n.tr("Frequency"), this.i18n.tr("Tx power dBm"), this.i18n.tr("Tx power mW")};
        int[] widths = new int[]{90, 120, 120, 100, 200, 90, 90, 90, 90, 90};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RadioInterfaceAPLabelProvider((TableViewer)this.viewer));
        this.viewer.setComparator((ViewerComparator)new RadioInterfaceAPComparator());
        this.createPopupMenu();
    }

    public void refresh() {
        if (this.getObject() == null) {
            this.viewer.setInput((Object)new RadioInterface[0]);
            return;
        }
        ArrayList<RadioInterface> list = new ArrayList<RadioInterface>();
        if (this.getObject() instanceof AccessPoint) {
            for (RadioInterface rif : ((AccessPoint)this.getObject()).getRadios()) {
                list.add(rif);
            }
        } else {
            for (RadioInterface rif : ((AbstractNode)this.getObject()).getRadios()) {
                list.add(rif);
            }
        }
        this.viewer.setInput(list);
        this.viewer.packColumns();
    }

    protected void onObjectUpdate(AbstractObject object) {
        this.refresh();
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }
}

