/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.MarkdownViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectOverviewView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.xnap.commons.i18n.I18n;

public class Comments
extends OverviewPageElement {
    private final I18n i18n = LocalizationHelper.getI18n(Comments.class);
    private MarkdownViewer markdownViewer;
    private Text textViewer;
    private Control currentViewer = null;
    private Composite content;
    private boolean markdownMode = false;
    private boolean showEmptyComments = !Registry.getSession().getClientConfigurationHintAsBoolean("ObjectOverview.ShowCommentsOnlyIfPresent", true);

    public Comments(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected Control createClientArea(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FillLayout());
        this.onObjectChange();
        return this.content;
    }

    private void createViewer(boolean markdownMode) {
        if (this.currentViewer != null && !this.currentViewer.isDisposed()) {
            if (this.markdownMode == markdownMode) {
                return;
            }
            this.currentViewer.dispose();
        }
        if (markdownMode) {
            this.markdownViewer = new MarkdownViewer(this.content, 0);
            this.markdownViewer.setRenderCompletionHandler(() -> {
                ObjectView view = this.getObjectView();
                if (view != null) {
                    ((ObjectOverviewView)view).requestElementLayout();
                }
            });
            this.currentViewer = this.markdownViewer;
        } else {
            this.textViewer = new Text(this.content, 770);
            this.textViewer.setFont(JFaceResources.getDialogFont());
            this.currentViewer = this.textViewer;
        }
        this.currentViewer.setBackground(this.getDisplay().getSystemColor(25));
        this.markdownMode = markdownMode;
    }

    protected String getTitle() {
        return this.i18n.tr("Comments");
    }

    protected void onObjectChange() {
        if (this.getObject() == null) {
            return;
        }
        String comments = this.getObject().getComments();
        if (comments.startsWith("{\u007f}")) {
            this.createViewer(true);
            this.markdownViewer.setText(comments.substring("{\u007f}".length()));
        } else {
            this.createViewer(false);
            this.textViewer.setText(comments);
        }
    }

    public boolean isApplicableForObject(AbstractObject object) {
        if (this.showEmptyComments) {
            return true;
        }
        String comments = object.getComments();
        return !comments.isBlank() && (!comments.startsWith("{\u007f}") || !comments.substring("{\u007f}".length()).isBlank());
    }
}

