/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.Card;
import org.netxms.nxmc.modules.objects.views.ObjectView;

public abstract class OverviewPageElement {
    private AbstractObject object = null;
    private Composite parent;
    private Card widget = null;
    private OverviewPageElement anchor;
    private int verticalAlignment = 128;
    private int horizontalSpan = 1;
    private ObjectView objectView;

    public OverviewPageElement(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        this.parent = parent;
        this.anchor = anchor;
        this.objectView = objectView;
    }

    public AbstractObject getObject() {
        return this.object;
    }

    public void setObject(AbstractObject object) {
        this.object = object;
        if (this.widget == null || this.widget.isDisposed()) {
            this.widget = new /* Unavailable Anonymous Inner Class!! */;
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = this.horizontalSpan;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = this.verticalAlignment;
            gd.heightHint = this.getHeightHint();
            this.widget.setLayoutData((Object)gd);
        }
        this.onObjectChange();
    }

    public void dispose() {
        if (this.widget != null && !this.widget.isDisposed()) {
            this.widget.dispose();
        }
    }

    public boolean isDisposed() {
        return this.widget == null || this.widget.isDisposed();
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return true;
    }

    public void fixPlacement() {
        if (this.widget != null && !this.widget.isDisposed()) {
            if (this.anchor == null) {
                this.widget.moveAbove(null);
            } else {
                this.widget.moveBelow(this.anchor.getAnchorControl());
            }
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public int getHorizontalSpan() {
        return this.horizontalSpan;
    }

    public void setHorizontalSpan(int horizontalSpan) {
        this.horizontalSpan = horizontalSpan;
    }

    private Control getAnchorControl() {
        if (this.widget != null && !this.widget.isDisposed()) {
            return this.widget;
        }
        if (this.anchor != null) {
            return this.anchor.getAnchorControl();
        }
        return null;
    }

    protected Display getDisplay() {
        return this.widget != null && !this.widget.isDisposed() ? this.widget.getDisplay() : Display.getCurrent();
    }

    protected ObjectView getObjectView() {
        return this.objectView;
    }

    protected abstract Control createClientArea(Composite var1);

    protected int getHeightHint() {
        return -1;
    }

    protected abstract void onObjectChange();

    protected abstract String getTitle();
}

