/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class ClusterResourceListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private I18n i18n = LocalizationHelper.getI18n(ClusterResourceListLabelProvider.class);
    private NXCSession session = Registry.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return StatusDisplayInfo.getStatusImage((Severity)(((ClusterResource)element).getCurrentOwner() != 0L ? Severity.NORMAL : Severity.MAJOR));
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((ClusterResource)element).getName();
            }
            case 1: {
                return ((ClusterResource)element).getVirtualAddress().getHostAddress();
            }
            case 2: {
                long ownerId = ((ClusterResource)element).getCurrentOwner();
                if (ownerId > 0L) {
                    Node owner = (Node)this.session.findObjectById(ownerId, Node.class);
                    return owner != null ? owner.getObjectName() : "<" + Long.toString(ownerId) + ">";
                }
                return this.i18n.tr("NONE");
            }
        }
        return null;
    }
}

