/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.nxmc.modules.objects.views.helpers.Dot1xPortSummary;

public class Dot1xPortListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private Color COLOR_UNKNOWN = new Color((Device)Display.getCurrent(), 127, 127, 127);
    private Color COLOR_FAILURE = new Color((Device)Display.getCurrent(), 255, 0, 0);
    private Color COLOR_POSSIBLE_FAILURE = new Color((Device)Display.getCurrent(), 255, 128, 0);
    private Color COLOR_AUTH_AUTO = new Color((Device)Display.getCurrent(), 0, 192, 0);
    private Color COLOR_AUTH_FORCED = new Color((Device)Display.getCurrent(), 0, 0, 128);

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Dot1xPortSummary port = (Dot1xPortSummary)element;
        switch (columnIndex) {
            case 0: {
                return port.getNodeName();
            }
            case 1: {
                return port.getPortName();
            }
            case 2: {
                return port.getInterfaceName();
            }
            case 3: {
                return port.getPaeStateAsText();
            }
            case 4: {
                return port.getBackendStateAsText();
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        Dot1xPortSummary port = (Dot1xPortSummary)element;
        if (port.getPaeState() == 0 || port.getPaeState() == 1) {
            return this.COLOR_UNKNOWN;
        }
        if (port.getPaeState() == 8) {
            return this.COLOR_AUTH_FORCED;
        }
        if (port.getPaeState() == 5) {
            return this.COLOR_AUTH_AUTO;
        }
        if (port.getPaeState() == 3) {
            return this.COLOR_POSSIBLE_FAILURE;
        }
        if (port.getPaeState() == 9 || port.getPaeState() == 7 || port.getBackendState() == 4 || port.getBackendState() == 5) {
            return this.COLOR_FAILURE;
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        Dot1xPortSummary port = (Dot1xPortSummary)element;
        if (port.getPaeState() == 9 || port.getPaeState() == 7 || port.getBackendState() == 4 || port.getBackendState() == 5 || port.getPaeState() == 3) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        return null;
    }

    public void dispose() {
        this.COLOR_AUTH_AUTO.dispose();
        this.COLOR_AUTH_FORCED.dispose();
        this.COLOR_FAILURE.dispose();
        this.COLOR_POSSIBLE_FAILURE.dispose();
        this.COLOR_UNKNOWN.dispose();
        super.dispose();
    }
}

