/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.objects.views.helpers.NodeSubObjectFilter;

public class InterfaceListFilter
extends NodeSubObjectFilter {
    private NXCSession session = Registry.getSession();
    private boolean hideSubInterfaces = false;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Interface iface = (Interface)element;
        if (this.hideSubInterfaces && iface.getParentInterfaceId() != 0L) {
            return false;
        }
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        return this.matchOId(iface) || this.matchName(iface) || this.matchAlias(iface) || this.matchIfType(iface) || this.matchIfIndex(iface) || this.matchIfTypeName(iface) || this.matchSlot(iface) || this.matchPort(iface) || this.matchMtu(iface) || this.matchSpeed(iface) || this.matchDescription(iface) || this.matchMac(iface) || this.matchIp(iface) || this.matchPeerInterface(iface) || this.matchPeerNode(iface) || this.matchPeerMac(iface) || this.matchPeerIp(iface) || this.matchPeerDiscoveryProtocol(iface) || this.matchAdminState(iface) || this.matchOperState(iface) || this.matchStpState(iface) || this.matchStatus(iface) || this.matchDot1xPaeState(iface) || this.matchDot1xBackendState(iface) || this.matchVendor(iface) || this.matchPeerVendor(iface);
    }

    private boolean matchOId(Interface iface) {
        return Long.toString(iface.getObjectId()).contains(this.filterString);
    }

    private boolean matchName(Interface iface) {
        return iface.getObjectName().toLowerCase().contains(this.filterString);
    }

    private boolean matchAlias(Interface interf) {
        return interf.getAlias().toLowerCase().contains(this.filterString);
    }

    private boolean matchIfType(Interface interf) {
        return Integer.toString(interf.getIfType()).toLowerCase().contains(this.filterString);
    }

    private boolean matchIfTypeName(Interface iface) {
        return iface.getIfTypeName().toLowerCase().contains(this.filterString);
    }

    private boolean matchIfIndex(Interface interf) {
        return Integer.toString(interf.getIfIndex()).toLowerCase().contains(this.filterString);
    }

    private boolean matchSlot(Interface interf) {
        return Integer.toString(interf.getModule()).toLowerCase().contains(this.filterString);
    }

    private boolean matchPort(Interface interf) {
        return Integer.toString(interf.getPort()).toLowerCase().contains(this.filterString);
    }

    private boolean matchMtu(Interface interf) {
        return Integer.toString(interf.getMtu()).toLowerCase().contains(this.filterString);
    }

    private boolean matchSpeed(Interface interf) {
        return Long.toString(interf.getSpeed()).toLowerCase().contains(this.filterString);
    }

    private boolean matchDescription(Interface interf) {
        return interf.getDescription().toLowerCase().contains(this.filterString);
    }

    private boolean matchMac(Interface interf) {
        return interf.getMacAddress().toString().toLowerCase().contains(this.filterString);
    }

    private boolean matchIp(Interface interf) {
        return interf.getIpAddressListAsString().toLowerCase().contains(this.filterString);
    }

    private boolean matchPeerNode(Interface iface) {
        return Long.toString(iface.getPeerNodeId()).toLowerCase().contains(this.filterString);
    }

    private boolean matchPeerInterface(Interface iface) {
        return Long.toString(iface.getPeerInterfaceId()).toLowerCase().contains(this.filterString);
    }

    private boolean matchPeerMac(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        if (peer == null) {
            return false;
        }
        return peer.getMacAddress().toString().toLowerCase().contains(this.filterString);
    }

    private boolean matchPeerIp(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        if (peer == null) {
            return false;
        }
        return peer.getIpAddressListAsString().toLowerCase().contains(this.filterString);
    }

    private boolean matchPeerDiscoveryProtocol(Interface iface) {
        return iface.getPeerDiscoveryProtocol().toString().toLowerCase().contains(this.filterString);
    }

    private boolean matchAdminState(Interface iface) {
        return iface.getAdminStateAsText().toLowerCase().contains(this.filterString);
    }

    private boolean matchOperState(Interface iface) {
        return iface.getOperStateAsText().toLowerCase().contains(this.filterString);
    }

    private boolean matchStpState(Interface iface) {
        return iface.getStpPortState().getText().toLowerCase().contains(this.filterString);
    }

    private boolean matchStatus(Interface iface) {
        return iface.getStatus().toString().toLowerCase().contains(this.filterString);
    }

    private boolean matchDot1xPaeState(Interface interf) {
        return interf.getDot1xPaeStateAsText().toLowerCase().contains(this.filterString);
    }

    private boolean matchDot1xBackendState(Interface interf) {
        return interf.getDot1xBackendStateAsText().toLowerCase().contains(this.filterString);
    }

    private boolean matchVendor(Interface iface) {
        String vendor = this.session.getVendorByMac(iface.getMacAddress(), null);
        return vendor != null && vendor.toLowerCase().contains(this.filterString);
    }

    private boolean matchPeerVendor(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        if (peer == null) {
            return false;
        }
        String vendor = this.session.getVendorByMac(peer.getMacAddress(), null);
        return vendor != null && vendor.toLowerCase().contains(this.filterString);
    }

    public boolean isHideSubInterfaces() {
        return this.hideSubInterfaces;
    }

    public void setHideSubInterfaces(boolean hideSubInterfaces) {
        this.hideSubInterfaces = hideSubInterfaces;
    }
}

