/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.NetworkService;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class NetworkServiceListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    public final String[] types = new String[]{"User defined", "SSH", "POP3", "SMTP", "FTP", "HTTP", "HTTPS", "Telnet"};
    public final String[] protocol = new String[256];
    private NXCSession session = Registry.getSession();

    public Color getForeground(Object element, int columnIndex) {
        NetworkService ns = (NetworkService)element;
        switch (columnIndex) {
            case 2: {
                StatusDisplayInfo.getStatusColor((ObjectStatus)ns.getStatus());
            }
        }
        this.initProtocolArray();
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        NetworkService ns = (NetworkService)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(ns.getObjectId());
            }
            case 1: {
                return ns.getObjectName();
            }
            case 2: {
                return StatusDisplayInfo.getStatusText((ObjectStatus)ns.getStatus());
            }
            case 3: {
                return this.types[ns.getServiceType()];
            }
            case 4: {
                return ns.getIpAddress().getHostAddress();
            }
            case 5: {
                return Integer.toString(ns.getPort());
            }
            case 6: {
                return ns.getRequest();
            }
            case 7: {
                return ns.getResponse();
            }
            case 8: {
                return this.getPollerName(ns);
            }
            case 9: {
                return Integer.toString(ns.getPollCount());
            }
        }
        return null;
    }

    public String getPollerName(NetworkService ns) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(ns.getPollerNode(), AbstractNode.class);
        return peer != null ? peer.getObjectName() : null;
    }

    private void initProtocolArray() {
        this.protocol[0] = "Dummy TCP";
    }
}

