/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.RadioInterface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;

public class RadioInterfaceAPComparator
extends ViewerComparator {
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        RadioInterface rif1 = (RadioInterface)e1;
        RadioInterface rif2 = (RadioInterface)e2;
        int result = switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 5 -> rif1.getBand().compareTo((Enum)rif2.getBand());
            case 3 -> rif1.getBSSID().compareTo(rif2.getBSSID());
            case 6 -> rif1.getChannel() - rif2.getChannel();
            case 7 -> rif1.getFrequency() - rif2.getFrequency();
            case 0 -> rif1.getIndex() - rif2.getIndex();
            case 4 -> this.getVendorByMAC(rif1.getBSSID()).compareToIgnoreCase(this.getVendorByMAC(rif2.getBSSID()));
            case 1 -> rif1.getName().compareToIgnoreCase(rif2.getName());
            case 2 -> rif1.getSSID().compareToIgnoreCase(rif2.getSSID());
            case 8 -> rif1.getPowerDBm() - rif2.getPowerDBm();
            case 9 -> rif1.getPowerMW() - rif2.getPowerMW();
            default -> 0;
        };
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendorByMAC(MacAddress macAddr) {
        String vendor = this.session.getVendorByMac(macAddr, null);
        return vendor != null ? vendor : "";
    }
}

