/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectCategorySelectionDialog;
import org.xnap.commons.i18n.I18n;

public class ObjectCategorySelector
extends AbstractSelector {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectCategorySelector.class);
    int categoryId = 0;

    public ObjectCategorySelector(Composite parent, int style) {
        super(parent, style, new SelectorConfigurator().setShowClearButton(true));
        this.setText(this.i18n.tr("<none>"));
    }

    protected void selectionButtonHandler() {
        ObjectCategory category;
        ObjectCategorySelectionDialog dlg = new ObjectCategorySelectionDialog(this.getShell());
        if (dlg.open() == 0 && (category = Registry.getSession().getObjectCategory(dlg.getCategoryId())) != null) {
            this.categoryId = category.getId();
            this.setText(category.getName());
        }
    }

    protected void clearButtonHandler() {
        this.categoryId = 0;
        this.setText(this.i18n.tr("<none>"));
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int categoryId) {
        if (categoryId == 0) {
            this.categoryId = 0;
            this.setText(this.i18n.tr("<none>"));
            return;
        }
        ObjectCategory category = Registry.getSession().getObjectCategory(categoryId);
        if (category != null) {
            this.categoryId = category.getId();
            this.setText(category.getName());
        } else {
            this.categoryId = 0;
            this.setText(this.i18n.tr("<none>"));
        }
    }
}

