/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class ObjectSelector
extends AbstractSelector {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectSelector.class);
    private long objectId = 0L;
    private AbstractObject object = null;
    private Set<Class<? extends AbstractObject>> objectClassSet = new HashSet();
    private Set<Integer> classFilter = null;
    private String emptySelectionName = this.i18n.tr("None");
    private String contextSelectionName = this.i18n.tr("<context>");
    private BaseObjectLabelProvider labelProvider = new BaseObjectLabelProvider();

    public ObjectSelector(Composite parent, int style, SelectorConfigurator configurator) {
        super(parent, style, configurator);
        this.setText(this.emptySelectionName);
        this.objectClassSet.add(Node.class);
        this.addDisposeListener((DisposeListener & Serializable)e -> this.labelProvider.dispose());
    }

    public ObjectSelector(Composite parent, int style, boolean showClearButton, boolean showContextButton) {
        this(parent, style, new SelectorConfigurator().setShowClearButton(showClearButton).setShowContextButton(showContextButton));
    }

    public ObjectSelector(Composite parent, int style, boolean showClearButton) {
        this(parent, style, showClearButton, false);
    }

    protected void selectionButtonHandler() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), this.classFilter);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            AbstractObject[] objects;
            AbstractObject[] abstractObjectArray = objects = this.objectClassSet != null ? dlg.getSelectedObjects(this.objectClassSet) : (AbstractObject[])dlg.getSelectedObjects().toArray(AbstractObject[]::new);
            if (objects.length > 0) {
                this.objectId = objects[0].getObjectId();
                this.object = objects[0];
                this.setText(objects[0].getNameWithAlias());
                this.setImage(this.labelProvider.getImage((Object)this.object));
            } else {
                this.objectId = 0L;
                this.object = null;
                this.setText(this.emptySelectionName);
                this.setImage(null);
            }
            this.fireModifyListeners();
        }
    }

    protected void contextButtonHandler() {
        this.objectId = 0xFFFFFFFFL;
        this.object = null;
        this.setText(this.contextSelectionName);
        this.setImage(null);
        this.fireModifyListeners();
    }

    protected void clearButtonHandler() {
        this.objectId = 0L;
        this.object = null;
        this.setText(this.emptySelectionName);
        this.setImage(null);
        this.fireModifyListeners();
    }

    public long getObjectId() {
        return this.objectId;
    }

    public AbstractObject getObject() {
        return this.object;
    }

    public String getObjectName() {
        return this.getText();
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
        if (objectId == 0L) {
            this.setText(this.emptySelectionName);
            this.setImage(null);
        } else if (objectId == 0xFFFFFFFFL) {
            this.setText(this.contextSelectionName);
            this.setImage(null);
        } else {
            this.object = Registry.getSession().findObjectById(objectId);
            this.setText((String)(this.object != null ? this.object.getObjectName() : "<" + Long.toString(objectId) + ">"));
            this.setImage(this.object != null ? this.labelProvider.getImage((Object)this.object) : SharedIcons.IMG_UNKNOWN_OBJECT);
        }
    }

    public Class<? extends AbstractObject> getObjectClass() {
        return (Class)this.objectClassSet.iterator().next();
    }

    public void setObjectClass(Class<? extends AbstractObject> objectClass) {
        this.objectClassSet.clear();
        this.objectClassSet.add(objectClass);
    }

    public void setObjectClass(Set<Class<? extends AbstractObject>> filterSet) {
        this.objectClassSet = filterSet;
    }

    public void removeSelectionClassFilter() {
        this.objectClassSet = null;
    }

    public String getEmptySelectionName() {
        return this.emptySelectionName;
    }

    public void setEmptySelectionName(String emptySelectionName) {
        this.emptySelectionName = emptySelectionName;
        if (this.objectId == 0L) {
            this.setText(emptySelectionName);
        }
    }

    public String getContextSelectionName() {
        return this.contextSelectionName;
    }

    public void setContextSelectionName(String contextSelectionName) {
        this.contextSelectionName = contextSelectionName;
    }

    public Set<Integer> getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Set<Integer> classFilter) {
        this.classFilter = classFilter;
    }

    public void initiateSelection() {
        this.selectionButtonHandler();
    }
}

