/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.base.Glob;
import org.netxms.base.InetAddressEx;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.VPNConnector;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;

public class ObjectViewerFilter
extends ViewerFilter {
    private static final int NONE = 0;
    private static final int NAME = 1;
    private static final int COMMENTS = 2;
    private static final int IP_ADDRESS_PATTERN = 3;
    private static final int IP_ADDRESS_EXACT = 4;
    private static final int OBJECT_ID = 5;
    private static final int ZONE = 6;
    private String filterString = null;
    private boolean hideUnmanaged = false;
    private boolean hideTemplateChecks = false;
    private boolean hideSubInterfaces = false;
    private boolean showHiddenObjects = false;
    private Map<Long, AbstractObject> objectList = null;
    private AbstractObject lastMatch = null;
    private List<AbstractObject> sourceObjects = null;
    private Set<Integer> classFilter = null;
    private boolean usePatternMatching = false;
    private int mode = 1;

    public ObjectViewerFilter(AbstractObject[] sourceObjects, Set<Integer> classFilter) {
        this.sourceObjects = sourceObjects != null ? Arrays.asList(sourceObjects) : null;
        this.classFilter = classFilter;
    }

    private boolean matchFilterString(AbstractObject object) {
        if (this.mode == 0 || this.filterString == null) {
            return true;
        }
        switch (this.mode) {
            case 2: {
                return object.getComments().toLowerCase().contains(this.filterString);
            }
            case 3: 
            case 4: {
                String address;
                if (object instanceof Interface) {
                    for (InetAddressEx a : ((Interface)object).getIpAddressList()) {
                        if (!(this.mode == 4 ? a.getHostAddress().equals(this.filterString) : a.getHostAddress().startsWith(this.filterString))) continue;
                        return true;
                    }
                    return false;
                }
                if (object instanceof AbstractNode) {
                    if (!((AbstractNode)object).getPrimaryIP().isValidAddress()) {
                        return false;
                    }
                    address = ((AbstractNode)object).getPrimaryIP().getHostAddress();
                } else if (object instanceof Subnet) {
                    address = ((Subnet)object).getSubnetAddress().getHostAddress();
                } else if (object instanceof AccessPoint) {
                    if (!((AccessPoint)object).getIpAddress().isValidAddress()) {
                        return false;
                    }
                    address = ((AccessPoint)object).getIpAddress().getHostAddress();
                } else {
                    return false;
                }
                return this.mode == 4 ? address.equals(this.filterString) : address.startsWith(this.filterString);
            }
            case 1: {
                return this.usePatternMatching ? Glob.matchIgnoreCase((String)this.filterString, (String)object.getNameWithAlias()) : object.getNameWithAlias().toLowerCase().contains(this.filterString);
            }
            case 5: {
                if (object instanceof AbstractObject) {
                    long objectID = object.getObjectId();
                    return String.valueOf(objectID).contentEquals(this.filterString);
                }
                return false;
            }
            case 6: {
                if (!(object instanceof AbstractNode)) break;
                int zoneUIN = ((AbstractNode)object).getZoneId();
                if (String.valueOf(zoneUIN).startsWith(this.filterString)) {
                    return true;
                }
                Zone zone = Registry.getSession().findZone(zoneUIN);
                if (zone == null) break;
                return this.usePatternMatching ? Glob.matchIgnoreCase((String)this.filterString, (String)zone.getObjectName()) : zone.getObjectName().toLowerCase().contains(this.filterString.toLowerCase());
            }
        }
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.passMainFilters(element)) {
            return false;
        }
        if (this.objectList == null) {
            return true;
        }
        boolean pass = this.objectList.containsKey(((AbstractObject)element).getObjectId());
        if (!pass) {
            if (((AbstractObject)element).hasChildren()) {
                for (AbstractObject o : this.objectList.values()) {
                    if (!o.isChildOf(((AbstractObject)element).getObjectId())) continue;
                    pass = true;
                    break;
                }
            } else if (((AbstractObject)element).hasParents() && (element instanceof Interface || element instanceof AccessPoint || element instanceof NetworkService || element instanceof VPNConnector)) {
                pass = this.objectList.containsKey(((AbstractObject)element).getParentIdList()[0]);
            }
        }
        return pass;
    }

    private boolean passMainFilters(Object element) {
        if (this.classFilter != null && !this.classFilter.contains(((AbstractObject)element).getObjectClass())) {
            return false;
        }
        if (this.hideUnmanaged && ((AbstractObject)element).getStatus() == ObjectStatus.UNMANAGED) {
            return false;
        }
        if (this.hideSubInterfaces && element instanceof Interface && ((Interface)element).getParentInterfaceId() != 0L) {
            return false;
        }
        return this.showHiddenObjects || !((AbstractObject)element).isHidden();
    }

    public void setFilterString(String filterString) {
        boolean fullSearch = true;
        if (filterString != null && !filterString.isEmpty()) {
            if (filterString.charAt(0) == '/') {
                this.mode = 2;
                String newFilterString = filterString.substring(1).toLowerCase();
                if (this.filterString != null && newFilterString.startsWith(this.filterString)) {
                    fullSearch = false;
                }
                this.filterString = newFilterString;
            } else if (filterString.charAt(0) == '>') {
                this.mode = 3;
                this.filterString = filterString.substring(1);
            } else if (filterString.charAt(0) == '^') {
                this.mode = 4;
                this.filterString = filterString.substring(1);
            } else if (filterString.charAt(0) == '#') {
                this.mode = 5;
                this.filterString = filterString.substring(1);
            } else if (filterString.charAt(0) == '@') {
                this.mode = 6;
                this.filterString = filterString.substring(1);
            } else {
                this.mode = 1;
                boolean bl = this.usePatternMatching = filterString.contains("*") || filterString.contains("?");
                if (this.usePatternMatching) {
                    this.filterString = filterString.toLowerCase() + "*";
                } else {
                    String newFilterString = filterString.toLowerCase();
                    if (this.filterString != null && newFilterString.startsWith(this.filterString)) {
                        fullSearch = false;
                    }
                    this.filterString = newFilterString;
                }
            }
        } else {
            this.filterString = null;
            this.usePatternMatching = false;
            this.mode = 0;
        }
        this.updateObjectList(fullSearch);
    }

    private void updateObjectList(boolean doFullSearch) {
        if (this.filterString != null) {
            if (doFullSearch) {
                List fullList = this.sourceObjects != null ? this.sourceObjects : Registry.getSession().getAllObjects();
                this.objectList = new HashMap();
                for (AbstractObject o : fullList) {
                    if (!this.matchFilterString(o) || !this.passMainFilters((Object)o)) continue;
                    this.objectList.put(o.getObjectId(), o);
                    this.lastMatch = o;
                }
            } else {
                this.lastMatch = null;
                Iterator it = this.objectList.values().iterator();
                while (it.hasNext()) {
                    AbstractObject obj = (AbstractObject)it.next();
                    if (!this.matchFilterString(obj) || !this.passMainFilters((Object)obj)) {
                        it.remove();
                        continue;
                    }
                    this.lastMatch = obj;
                }
            }
        } else {
            this.objectList = null;
            this.lastMatch = null;
        }
    }

    public final AbstractObject getLastMatch() {
        return this.lastMatch;
    }

    public boolean isHideUnmanaged() {
        return this.hideUnmanaged;
    }

    public void setHideUnmanaged(boolean hideUnmanaged) {
        this.hideUnmanaged = hideUnmanaged;
    }

    public boolean isHideTemplateChecks() {
        return this.hideTemplateChecks;
    }

    public void setHideTemplateChecks(boolean hideTemplateChecks) {
        this.hideTemplateChecks = hideTemplateChecks;
    }

    public boolean isHideSubInterfaces() {
        return this.hideSubInterfaces;
    }

    public void setHideSubInterfaces(boolean hideSubInterfaces) {
        this.hideSubInterfaces = hideSubInterfaces;
    }

    public boolean isShowHiddenObjects() {
        return this.showHiddenObjects;
    }

    public void setShowHiddenObjects(boolean showHiddenObjects) {
        this.showHiddenObjects = showHiddenObjects;
    }
}

