/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.modules.objecttools.TcpPortForwarder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpPortForwarder {
    private static final Logger logger = LoggerFactory.getLogger(TcpPortForwarder.class);
    private UUID id;
    private Display display = null;
    private MessageAreaHolder messageArea = null;
    private NXCSession session;
    private long nodeId;
    private int remotePort;
    private boolean useLocalAgent;
    private ServerSocket listener;
    private int sessionId = 0;
    private int messageId = 0;
    private Map<Integer, Session> sessions = new HashMap();
    private TextOutputListener outputListener = null;

    public TcpPortForwarder(NXCSession session, long nodeId, int remotePort, int listenerTimeout) throws IOException {
        this(session, nodeId, false, remotePort, listenerTimeout);
    }

    public TcpPortForwarder(NXCSession session, long nodeId, boolean useLocalAgent, int remotePort, int listenerTimeout) throws IOException {
        this.id = UUID.randomUUID();
        this.session = session;
        this.nodeId = nodeId;
        this.remotePort = remotePort;
        this.useLocalAgent = useLocalAgent;
        this.listener = new ServerSocket(0);
        this.listener.setSoTimeout(listenerTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Object mutex = new Object();
        Thread thread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "TcpForwarder");
        thread.setDaemon(true);
        Object object = mutex;
        synchronized (object) {
            thread.start();
            mutex.wait();
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        logger.debug("Closing TCP forwarder instance on port " + this.listener.getLocalPort());
        try {
            this.listener.close();
        }
        catch (Exception e) {
            logger.debug("Error closing listening socket", (Throwable)e);
        }
        Map map = this.sessions;
        synchronized (map) {
            for (Session s : this.sessions.values()) {
                s.close();
            }
            this.sessions.clear();
        }
    }

    public int getLocalPort() {
        return this.listener.getLocalPort();
    }

    public TextOutputListener getConsoleOutputStream() {
        return this.outputListener;
    }

    public void setConsoleOutputListener(TextOutputListener consoleOutputStream) {
        this.outputListener = consoleOutputStream;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public MessageAreaHolder getMessageArea() {
        return this.messageArea;
    }

    public void setMessageArea(MessageAreaHolder messageArea) {
        this.messageArea = messageArea;
    }

    public UUID getId() {
        return this.id;
    }
}

