/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.client.objecttools.ObjectToolTableColumn;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objecttools.dialogs.EditColumnDialog;
import org.netxms.nxmc.modules.objecttools.propertypages.helpers.ToolColumnLabelProvider;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class Columns
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(Columns.class);
    private ObjectToolDetails objectTool;
    private List<ObjectToolTableColumn> columns = new ArrayList();
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;

    public Columns(ObjectToolDetails toolDetails) {
        super("Columns");
        this.noDefaultAndApplyButton();
        this.objectTool = toolDetails;
    }

    protected Control createContents(Composite parent) {
        for (ObjectToolTableColumn tc : this.objectTool.getColumns()) {
            this.columns.add(new ObjectToolTableColumn(tc));
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ToolColumnLabelProvider(this.objectTool.getToolType() == 2));
        this.setupTableColumns();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setInput((Object)this.columns.toArray());
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText(this.i18n.tr("&Add..."));
        this.buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(buttons, 8);
        this.buttonEdit.setText(this.i18n.tr("&Edit..."));
        this.buttonEdit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText(this.i18n.tr("&Delete"));
        this.buttonRemove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        return dialogArea;
    }

    private void setupTableColumns() {
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText(this.i18n.tr("Name"));
        column.setWidth(200);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText(this.i18n.tr("Format"));
        column.setWidth(90);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText(this.objectTool.getToolType() == 2 ? this.i18n.tr("OID") : this.i18n.tr("Index"));
        column.setWidth(200);
        this.viewer.getTable().setHeaderVisible(true);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (String)"ColumnsPropertyPage");
    }

    private void addColumn() {
        ObjectToolTableColumn tc = new ObjectToolTableColumn(this.i18n.tr("Column ") + Integer.toString(this.columns.size() + 1));
        EditColumnDialog dlg = new EditColumnDialog(this.getShell(), true, this.objectTool.getToolType() == 2, tc);
        if (dlg.open() == 0) {
            this.columns.add(tc);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)tc));
        }
    }

    private void editColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        EditColumnDialog dlg = new EditColumnDialog(this.getShell(), false, this.objectTool.getToolType() == 2, (ObjectToolTableColumn)selection.getFirstElement());
        dlg.open();
        this.viewer.update(selection.getFirstElement(), null);
    }

    private void removeColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.columns.remove(it.next());
        }
        this.viewer.setInput((Object)this.columns.toArray());
    }

    protected boolean applyChanges(boolean isApply) {
        this.objectTool.setColumns(this.columns);
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (String)"ColumnsPropertyPage");
        return true;
    }

    public boolean performCancel() {
        if (this.isControlCreated()) {
            WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (String)"ColumnsPropertyPage");
        }
        return super.performCancel();
    }
}

