/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.modules.reporting.widgets.ReportFieldEditor;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class ObjectListFieldEditor
extends ReportFieldEditor {
    private I18n i18n;
    private TableViewer viewer;
    private Map<Long, AbstractObject> objects = new HashMap();

    public ObjectListFieldEditor(ReportParameter parameter, Composite parent) {
        super(parameter, parent);
    }

    protected void setupLocalization() {
        this.i18n = LocalizationHelper.getI18n(ObjectListFieldEditor.class);
    }

    protected Control createContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.viewer = new TableViewer(content, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingObjectLabelProvider());
        this.viewer.setInput((Object)new Object[0]);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gd);
        ImageHyperlink link = new ImageHyperlink(content, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        link.setText(this.i18n.tr("Add"));
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link = new ImageHyperlink(content, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setText(this.i18n.tr("Remove"));
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        return content;
    }

    private void addObjects() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            for (AbstractObject o : dlg.getSelectedObjects()) {
                this.objects.put(o.getObjectId(), o);
            }
            this.viewer.setInput((Object)this.objects.values().toArray());
        }
    }

    private void removeObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.objects.remove(((AbstractObject)o).getObjectId());
        }
        this.viewer.setInput((Object)this.objects.values().toArray());
    }

    public String getValue() {
        if (this.objects.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (AbstractObject o : this.objects.values()) {
            sb.append(o.getObjectId());
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

