/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.propertypages;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AuthenticationToken;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.dialogs.IssueTokenDialog;
import org.netxms.nxmc.modules.users.propertypages.TokenManagement;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class TokenManagement
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(TokenManagement.class);
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_DESCRIPTION = 1;
    private static final int COLUMN_CREATED = 2;
    private static final int COLUMN_EXPIRES = 3;
    private NXCSession session = Registry.getSession();
    private User user;
    private List<AuthenticationToken> tokens;
    private SortableTableViewer viewer;
    private Button revokeButton;

    public TokenManagement(User user, MessageAreaHolder messageArea) {
        super(LocalizationHelper.getI18n(TokenManagement.class).tr("Authentication Tokens"), messageArea);
        this.user = user;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("ID"), this.i18n.tr("Description"), this.i18n.tr("Created"), this.i18n.tr("Expires")};
        int[] columnWidths = new int[]{80, 200, 150, 150};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TokenListLabelProvider(this));
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        Button issueButton = new Button(buttons, 8);
        issueButton.setText(this.i18n.tr("&Issue New..."));
        RowData rd = new RowData();
        rd.width = 90;
        issueButton.setLayoutData((Object)rd);
        issueButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.revokeButton = new Button(buttons, 8);
        this.revokeButton.setText(this.i18n.tr("&Revoke"));
        rd = new RowData();
        rd.width = 90;
        this.revokeButton.setLayoutData((Object)rd);
        this.revokeButton.setEnabled(false);
        this.revokeButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.loadTokens();
        return dialogArea;
    }

    private void loadTokens() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void issueToken() {
        IssueTokenDialog dlg = new IssueTokenDialog(this.getShell(), this.user.getId());
        dlg.open();
        this.loadTokens();
    }

    private void revokeTokens() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Confirm Revocation"), (String)this.i18n.tr("Are you sure you want to revoke selected authentication token(s)?"))) {
            return;
        }
        int[] tokenIds = selection.toList().stream().mapToInt(o -> ((AuthenticationToken)o).getId()).toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected boolean applyChanges(boolean isApply) {
        return true;
    }
}

