/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.reports.acl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.reports.acl.AbstractAclReport;
import org.netxms.nxmc.modules.users.reports.acl.constants.PermissionsSheetCells;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractAclReport {
    private final I18n i18n = LocalizationHelper.getI18n(AbstractAclReport.class);
    protected final String SHEET_USERS = this.i18n.tr("Users");
    protected final String SHEET_GROUPS = this.i18n.tr("Groups");
    protected final String SHEET_PERMISSIONS = this.i18n.tr("Object Permissions");
    protected NXCSession session = Registry.getSession();
    private String outputFileName;

    public AbstractAclReport(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void execute() throws IOException, NXCException {
        ArrayList permissions = new ArrayList();
        AbstractObject[] topLevelObjects = this.session.getTopLevelObjects();
        for (AbstractObject topLevelObject : topLevelObjects) {
            AbstractAclReport.scanACL((AbstractObject)topLevelObject, (String)"", permissions);
        }
        for (ObjectAccess row : permissions) {
            AbstractUserObject user = this.session.findUserDBObjectById(row.userId, null);
            if (user != null) {
                row.userName = user.getName();
                if (user instanceof User) continue;
                row.userName = row.userName + this.i18n.tr(" (group)");
                continue;
            }
            row.userName = String.format(this.i18n.tr("DELETED [%d]"), row.userId);
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFFont headerFont = wb.createFont();
        headerFont.setBold(true);
        XSSFCellStyle headerCellStyle = wb.createCellStyle();
        headerCellStyle.setFont((Font)headerFont);
        wb.createSheet();
        wb.createSheet();
        wb.createSheet();
        wb.setSheetName(0, this.SHEET_USERS);
        wb.setSheetName(1, this.SHEET_GROUPS);
        wb.setSheetName(2, this.SHEET_PERMISSIONS);
        this.generateUserSheet(wb, headerCellStyle);
        this.generateGroupsSheet(wb, headerCellStyle);
        this.generatePermissionsSheet(wb, headerCellStyle, permissions);
        try (FileOutputStream fileOut = new FileOutputStream(this.outputFileName);){
            wb.write((OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
    }

    protected void createPermissionCell(XSSFRow row, int columnIndex, long accessBit, AbstractUserObject userObject) {
        row.createCell(columnIndex).setCellValue((userObject.getSystemRights() & accessBit) != 0L ? this.i18n.tr("YES") : this.i18n.tr("NO"));
    }

    protected abstract void generateUserSheet(XSSFWorkbook var1, XSSFCellStyle var2);

    protected abstract void generateGroupsSheet(XSSFWorkbook var1, XSSFCellStyle var2);

    protected abstract void generatePermissionsSheet(XSSFWorkbook var1, XSSFCellStyle var2, List<ObjectAccess> var3);

    protected void createPermissionCell(XSSFRow row, PermissionsSheetCells cellId, int accessBit, ObjectAccess element) {
        row.createCell(cellId.ordinal()).setCellValue((element.accessRights & accessBit) != 0 ? this.i18n.tr("YES") : this.i18n.tr("NO"));
    }

    protected static void scanACL(AbstractObject currentObject, String parentFullName, List<ObjectAccess> results) {
        String currentFullName = parentFullName + "/" + currentObject.getObjectName();
        AbstractAclReport.processObject((AbstractObject)currentObject, (String)currentFullName, results);
        for (AbstractObject abstractObject : currentObject.getChildrenAsArray()) {
            if (!abstractObject.hasChildren()) continue;
            AbstractAclReport.scanACL((AbstractObject)abstractObject, (String)currentFullName, results);
        }
    }

    protected static void processObject(AbstractObject currentObject, String fullName, List<ObjectAccess> results) {
        if (currentObject.isInheritAccessRights() && currentObject.getAccessList().length == 0) {
            return;
        }
        for (AccessListElement element : currentObject.getAccessList()) {
            results.add(new ObjectAccess(fullName, currentObject.isInheritAccessRights(), element.getUserId(), element.getAccessRights()));
        }
    }
}

