/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.widgets;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.dialogs.UserSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class UserSelector
extends AbstractSelector {
    private final I18n i18n = LocalizationHelper.getI18n(UserSelector.class);
    private int userId = -1;
    private Image imageUser;
    private Image imageGroup;

    public UserSelector(Composite parent, int style) {
        this(parent, style, new SelectorConfigurator());
    }

    public UserSelector(Composite parent, int style, SelectorConfigurator configurator) {
        super(parent, style, configurator.setSelectionButtonToolTip(LocalizationHelper.getI18n(UserSelector.class).tr("Select user")));
        this.setText(this.i18n.tr("<none>"));
        this.imageUser = ResourceManager.getImage((String)"icons/user.png");
        this.imageGroup = ResourceManager.getImage((String)"icons/group.png");
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void selectionButtonHandler() {
        UserSelectionDialog dlg = new UserSelectionDialog(this.getShell(), null);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            long prevUserId = this.userId;
            AbstractUserObject[] users = dlg.getSelection();
            if (users.length > 0) {
                this.userId = users[0].getId();
                this.setText(users[0].getName());
                this.setImage(users[0] instanceof User ? this.imageUser : this.imageGroup);
            } else {
                this.userId = 0;
                this.setText(this.i18n.tr("<none>"));
                this.setImage(null);
            }
            if (prevUserId != (long)this.userId) {
                this.fireModifyListeners();
            }
        }
    }

    protected void clearButtonHandler() {
        if (this.userId == 0) {
            return;
        }
        this.userId = -1;
        this.setText(this.i18n.tr("<none>"));
        this.setImage(null);
        this.getTextControl().setToolTipText(null);
        this.fireModifyListeners();
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        if (this.userId == userId) {
            return;
        }
        this.userId = userId;
        if (userId != -1) {
            AbstractUserObject object = Registry.getSession().findUserDBObjectById(userId, () -> {
                AbstractUserObject updatedObject = Registry.getSession().findUserDBObjectById(userId, null);
                if (updatedObject != null) {
                    this.getDisplay().asyncExec(() -> {
                        if (!this.isDisposed()) {
                            this.setText(updatedObject.getName());
                            this.setImage(updatedObject instanceof User ? this.imageUser : this.imageGroup);
                        }
                    });
                }
            });
            if (object != null) {
                this.setText(object.getName());
                this.setImage(object instanceof User ? this.imageUser : this.imageGroup);
            } else {
                this.setText("[" + userId + "]");
                this.setImage(null);
            }
        } else {
            this.setText(this.i18n.tr("<none>"));
            this.setImage(null);
        }
        this.fireModifyListeners();
    }
}

