/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.worldmap.GeoMapListener;
import org.netxms.nxmc.modules.worldmap.tools.MapAccessor;
import org.netxms.nxmc.modules.worldmap.views.ObjectGeoLocationView;
import org.netxms.nxmc.modules.worldmap.widgets.ObjectGeoLocationViewer;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ObjectGeoLocationView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectGeoLocationView.class);
    private ObjectGeoLocationViewer map;
    private MapAccessor mapAccessor;
    private PreferenceStore settings = PreferenceStore.getInstance();
    private int zoomLevel = 3;
    private boolean showPending = false;
    private boolean hideOtherObjects = false;
    private Action actionCoordinates;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private Action actionHideOtherObjects;
    private Action actionUpdateObjectLocation;

    public ObjectGeoLocationView() {
        super(LocalizationHelper.getI18n(ObjectGeoLocationView.class).tr("Geolocation"), ResourceManager.getImageDescriptor((String)"icons/object-views/geolocation.png"), "GeoLocation", false);
    }

    public boolean isValidForContext(Object context) {
        return super.isValidForContext(context) && ((AbstractObject)context).getGeolocation().getType() != 0;
    }

    public int getPriority() {
        return 300;
    }

    protected void onObjectChange(AbstractObject object) {
        GeoLocation l;
        GeoLocation geoLocation = l = object != null ? object.getGeolocation() : new GeoLocation(false);
        if (l.getType() != 0) {
            this.mapAccessor.setLatitude(l.getLatitude());
            this.mapAccessor.setLongitude(l.getLongitude());
        } else {
            this.mapAccessor.setLatitude(0.0);
            this.mapAccessor.setLongitude(0.0);
        }
        if (this.hideOtherObjects) {
            this.map.setRootObjectId(object.getObjectId());
        }
        if (this.isVisible()) {
            this.map.showMap(this.mapAccessor);
        } else {
            this.showPending = true;
        }
    }

    public void activate() {
        super.activate();
        if (this.showPending) {
            this.map.showMap(this.mapAccessor);
            this.showPending = false;
        }
    }

    protected void createContent(Composite parent) {
        this.map = new ObjectGeoLocationViewer(parent, 0, (View)this);
        this.hideOtherObjects = this.settings.getAsBoolean(this.getBaseId() + ".hideOtherObjects", this.hideOtherObjects);
        if (this.hideOtherObjects) {
            this.map.setSingleObjectMode(true);
            this.map.setRootObjectId(this.getObjectId());
        }
        this.createActions();
        this.createPopupMenu();
        this.mapAccessor = new MapAccessor(this.getObject() != null ? this.getObject().getGeolocation() : new GeoLocation(false));
        this.zoomLevel = this.settings.getAsInteger(this.getBaseId() + ".zoom", 15);
        this.mapAccessor.setZoom(this.zoomLevel);
        if (this.isVisible()) {
            this.map.showMap(this.mapAccessor);
        } else {
            this.showPending = true;
        }
        this.map.addMapListener((GeoMapListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createActions() {
        this.actionZoomIn = new /* Unavailable Anonymous Inner Class!! */;
        this.actionZoomOut = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideOtherObjects = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideOtherObjects.setChecked(this.hideOtherObjects);
        this.actionUpdateObjectLocation = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCoordinates = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        7 menuMgr = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuMgr.createContextMenu((Control)this.map);
        this.map.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.actionCoordinates.setText(this.map.getLocationAtPoint(this.map.getCurrentPoint()).toString());
        manager.add((IAction)this.actionCoordinates);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideOtherObjects);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionUpdateObjectLocation);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideOtherObjects);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideOtherObjects);
    }

    public void dispose() {
        this.settings.set(this.getBaseId() + ".hideOtherObjects", this.hideOtherObjects);
        this.settings.set(this.getBaseId() + ".zoom", this.mapAccessor.getZoom());
        super.dispose();
    }

    private void setZoomLevel(int newLevel) {
        if (newLevel < 0 || newLevel > 19) {
            return;
        }
        this.zoomLevel = newLevel;
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.actionZoomIn.setEnabled(this.zoomLevel < 19);
        this.actionZoomOut.setEnabled(this.zoomLevel > 0);
    }

    private void updateObjectLocation() {
        NXCObjectModificationData md = new NXCObjectModificationData(this.getObjectId());
        md.setGeolocation(this.map.getLocationAtPoint(this.map.getCurrentPoint()));
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    static /* synthetic */ NXCSession access$000(ObjectGeoLocationView x0) {
        return x0.session;
    }
}

