/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class FontCache
implements DisposeListener {
    private Map<String, Font> cache = new HashMap();

    public FontCache() {
    }

    public FontCache(Control control) {
        control.addDisposeListener((DisposeListener)this);
    }

    public Font create(String name, int height, int style) {
        String key = name + "@" + Integer.toString(height) + "-" + Integer.toString(style);
        Font font = (Font)this.cache.get(key);
        if (font == null) {
            font = new Font((Device)Display.getCurrent(), name, height, style);
            this.cache.put(key, font);
        }
        return font;
    }

    public Font create(String name, int height) {
        return this.create(name, height, 0);
    }

    public void dispose() {
        for (Font f : this.cache.values()) {
            f.dispose();
        }
        this.cache.clear();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }
}

