/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import org.netxms.base.MacAddress;
import org.netxms.base.MacAddressFormatException;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.xnap.commons.i18n.I18n;

public class MacAddressValidator
implements TextFieldValidator {
    private I18n i18n = LocalizationHelper.getI18n(MacAddressValidator.class);
    private boolean allowEmpty;

    public MacAddressValidator(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public boolean validate(String text) {
        if (this.allowEmpty && text.trim().isEmpty()) {
            return true;
        }
        try {
            MacAddress.parseMacAddress((String)text);
            return true;
        }
        catch (MacAddressFormatException e) {
            return false;
        }
    }

    public String getErrorMessage(String text) {
        return this.i18n.tr("Invalid MAC address");
    }
}

