/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.login;

import java.security.Signature;
import java.security.cert.Certificate;
import org.netxms.client.constants.AuthenticationType;

public class LoginCredentials {
    private final String server;
    private final String loginName;
    private final AuthenticationType authMethod;
    private final String password;
    private final Certificate certificate;
    private final Signature signature;

    public LoginCredentials(String server, String loginName, String password) {
        this.server = server;
        this.loginName = loginName;
        this.authMethod = AuthenticationType.PASSWORD;
        this.password = password;
        this.certificate = null;
        this.signature = null;
    }

    public LoginCredentials(String server, String loginName, Certificate certificate, Signature signature) {
        this.server = server;
        this.loginName = loginName;
        this.authMethod = AuthenticationType.CERTIFICATE;
        this.password = null;
        this.certificate = certificate;
        this.signature = signature;
    }

    private LoginCredentials(String server, String token) {
        this.server = server;
        this.loginName = token;
        this.authMethod = AuthenticationType.TOKEN;
        this.password = null;
        this.certificate = null;
        this.signature = null;
    }

    public static LoginCredentials forToken(String server, String token) {
        return new LoginCredentials(server, token);
    }

    public String getServer() {
        return this.server;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public AuthenticationType getAuthMethod() {
        return this.authMethod;
    }

    public String getPassword() {
        return this.password;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public Signature getSignature() {
        return this.signature;
    }
}

