/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.ai.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class AiTaskEditDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(AiTaskEditDialog.class);
    private LabeledText textDescription;
    private LabeledText textPrompt;
    private String description;
    private String prompt;
    private boolean isNew;

    public AiTaskEditDialog(Shell parentShell, String description, String prompt, boolean isNew) {
        super(parentShell);
        this.description = description;
        this.prompt = prompt;
        this.isNew = isNew;
    }

    public AiTaskEditDialog(Shell parentShell) {
        this(parentShell, null, null, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.isNew ? this.i18n.tr("Create AI Task") : this.i18n.tr("Edit AI Task"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel(this.i18n.tr("Description"));
        this.textDescription.getTextControl().setTextLimit(256);
        if (this.description != null) {
            this.textDescription.setText(this.description);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.textDescription.setLayoutData((Object)gd);
        this.textPrompt = new LabeledText(dialogArea, 0, 2626);
        this.textPrompt.setLabel(this.i18n.tr("Prompt"));
        if (this.prompt != null) {
            this.textPrompt.setText(this.prompt);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.widthHint = 400;
        this.textPrompt.setLayoutData((Object)gd);
        if (this.description == null) {
            this.textDescription.setFocus();
        } else {
            this.textPrompt.setFocus();
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.description = this.textDescription.getText().trim();
        this.prompt = this.textPrompt.getText().trim();
        super.okPressed();
    }

    public String getDescription() {
        return this.description;
    }

    public String getPrompt() {
        return this.prompt;
    }
}

