/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netxms.client.datacollection.DciTemplateConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.DciIdMatchingData;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="element", strict=false)
public class TableValueConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=true)
    private long dciId = 0L;
    @Element(required=false)
    public String dciName;
    @Element(required=false)
    public String dciDescription;
    @Element(required=false)
    public String dciTag;
    @Element(required=false)
    private DciTemplateConfig templateConfig;
    @Element(required=false)
    private int refreshRate = 30;
    @Element(required=false)
    private String sortColumn = null;
    @Element(required=false)
    private int sortDirection = 128;

    public Set<Long> getObjects() {
        Set objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public Map<Long, Long> getDataCollectionItems() {
        HashMap<Long, Long> dcis = new HashMap<Long, Long>();
        dcis.put(this.dciId, this.objectId);
        return dcis;
    }

    public void remapDataCollectionItems(Map<Long, DciIdMatchingData> remapData) {
        super.remapDataCollectionItems(remapData);
        DciIdMatchingData md = remapData.get(this.dciId);
        if (md != null) {
            this.objectId = md.dstNodeId;
            this.dciId = md.dstDciId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long dciId) {
        this.dciId = dciId;
    }

    public String getDciName() {
        return this.dciName != null ? this.dciName : "";
    }

    public void setDciName(String dciName) {
        this.dciName = dciName;
    }

    public String getDciDescription() {
        return this.dciDescription != null ? this.dciDescription : "";
    }

    public void setDciDescription(String dciDescription) {
        this.dciDescription = dciDescription;
    }

    public String getDciTag() {
        return this.dciTag != null ? this.dciTag : "";
    }

    public void setDciTag(String dciTag) {
        this.dciTag = dciTag;
    }

    public DciTemplateConfig getTemplateConfig() {
        if (this.templateConfig == null) {
            this.templateConfig = new DciTemplateConfig();
            this.templateConfig.setDciName(this.getDciName());
            this.templateConfig.setDciDescription(this.getDciDescription());
            this.templateConfig.setDciTag(this.getDciTag());
        }
        return this.templateConfig;
    }

    public void applyTemplateConfig(DciTemplateConfig config) {
        this.templateConfig = config;
        this.dciName = config.getDciName();
        this.dciDescription = config.getDciDescription();
        this.dciTag = config.getDciTag();
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }
}

