/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.WinPerfCounter;
import org.netxms.client.datacollection.WinPerfObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.helpers.StringComparator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.WinPerfObjectTreeContentProvider;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.WinPerfObjectTreeLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class WinPerfCounterSelectionDialog
extends Dialog
implements IParameterSelectionDialog {
    private final I18n i18n = LocalizationHelper.getI18n(WinPerfCounterSelectionDialog.class);
    private long nodeId;
    private TreeViewer objectTree;
    private TableViewer instanceList;
    private WinPerfCounter selectedCounter = null;
    private String selectedInstance = null;

    public WinPerfCounterSelectionDialog(Shell parentShell, long nodeId) {
        super(parentShell);
        this.nodeId = nodeId;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select Windows Performance Counter"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 2;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText(this.i18n.tr("Objects and counters"));
        new Label(dialogArea, 0).setText(this.i18n.tr("Instances"));
        this.objectTree = new TreeViewer(dialogArea, 67584);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        gd.widthHint = 350;
        this.objectTree.getControl().setLayoutData((Object)gd);
        this.objectTree.setContentProvider((IContentProvider)new WinPerfObjectTreeContentProvider());
        this.objectTree.setLabelProvider((IBaseLabelProvider)new WinPerfObjectTreeLabelProvider());
        this.objectTree.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.objectTree.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.instanceList = new TableViewer(dialogArea, 67584);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 350;
        this.instanceList.getControl().setLayoutData((Object)gd);
        this.instanceList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.instanceList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.instanceList.setComparator((ViewerComparator)new StringComparator());
        this.objectTree.setInput((Object)WinPerfObject.createPlaceholderList((String)this.i18n.tr("Loading...")));
        this.fillData();
        return dialogArea;
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    private void fillData() {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void onObjectSelection() {
        ITreeSelection selection = this.objectTree.getStructuredSelection();
        if (selection.size() == 0) {
            this.instanceList.setInput((Object)new String[0]);
            return;
        }
        WinPerfObject object = selection.getFirstElement() instanceof WinPerfObject ? (WinPerfObject)selection.getFirstElement() : ((WinPerfCounter)selection.getFirstElement()).getObject();
        this.instanceList.setInput((Object)object.getInstances());
        this.instanceList.getTable().setEnabled(object.hasInstances());
        this.selectedCounter = selection.getFirstElement() instanceof WinPerfCounter ? (WinPerfCounter)selection.getFirstElement() : null;
    }

    protected void okPressed() {
        if (this.selectedCounter == null) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select counter and instance and then press OK"));
            return;
        }
        if (this.selectedCounter.getObject().hasInstances()) {
            IStructuredSelection selection = this.instanceList.getStructuredSelection();
            if (selection.size() != 1) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select counter and instance and then press OK"));
                return;
            }
            this.selectedInstance = (String)selection.getFirstElement();
        } else {
            this.selectedInstance = null;
        }
        super.okPressed();
    }

    public String getParameterName() {
        if (this.selectedInstance == null) {
            return "\\" + this.selectedCounter.getObject().getName() + "\\" + this.selectedCounter.getName();
        }
        return "\\" + this.selectedCounter.getObject().getName() + "(" + this.selectedInstance + ")\\" + this.selectedCounter.getName();
    }

    public String getParameterDescription() {
        if (this.selectedInstance == null) {
            return this.selectedCounter.getObject().getName() + ": " + this.selectedCounter.getName();
        }
        return this.selectedCounter.getObject().getName() + ": " + this.selectedCounter.getName() + this.i18n.tr(" for ") + this.selectedInstance;
    }

    public DataType getParameterDataType() {
        return DataType.INT64;
    }

    public String getInstanceColumn() {
        return "";
    }

    static /* synthetic */ Button access$000(WinPerfCounterSelectionDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

