/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.client.datacollection.DciValue;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.EditDciSummaryTableColumnDlg;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectDciDialog;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.SummaryTableColumnLabelProvider;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SummaryTableColumns
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(SummaryTableColumns.class);
    private static final String COLUMN_SETTINGS_PREFIX = "SummaryTableColumns.ColumnList";
    private DciSummaryTable table;
    private List<DciSummaryTableColumn> columns;
    private TableViewer viewer;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private Button importButton;

    public SummaryTableColumns(DciSummaryTable table) {
        super(LocalizationHelper.getI18n(SummaryTableColumns.class).tr("Columns"));
        this.table = table;
    }

    protected Control createContents(Composite parent) {
        this.columns = new ArrayList(this.table.getColumns().size());
        for (DciSummaryTableColumn c : this.table.getColumns()) {
            this.columns.add(new DciSummaryTableColumn(c));
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText(this.i18n.tr("Columns"));
        this.viewer = new TableViewer(dialogArea, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.setupColumnList();
        this.viewer.setInput((Object)this.columns.toArray());
        Composite leftButtons = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("&Down"));
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.importButton = new Button(buttons, 8);
        this.importButton.setText(this.i18n.tr("Import"));
        RowData rd = new RowData();
        rd.width = 90;
        this.importButton.setLayoutData((Object)rd);
        this.importButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.modifyButton = new Button(buttons, 8);
        this.modifyButton.setText(this.i18n.tr("&Edit..."));
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void setupColumnList() {
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Name"));
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        column.setText(this.i18n.tr("Metric"));
        column.setWidth(250);
        WidgetHelper.restoreColumnSettings((Table)table, (String)COLUMN_SETTINGS_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SummaryTableColumnLabelProvider());
    }

    protected boolean applyChanges(boolean isApply) {
        this.saveSettings();
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (String)COLUMN_SETTINGS_PREFIX);
    }

    private void moveUp() {
        DciSummaryTableColumn column;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.columns.indexOf(column = (DciSummaryTableColumn)selection.getFirstElement())) > 0) {
            Collections.swap(this.columns, index - 1, index);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    private void moveDown() {
        DciSummaryTableColumn column;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.columns.indexOf(column = (DciSummaryTableColumn)selection.getFirstElement())) < this.columns.size() - 1 && index >= 0) {
            Collections.swap(this.columns, index + 1, index);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    private void deleteColumns() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.columns.remove(it.next());
            }
            this.viewer.setInput((Object)this.columns.toArray());
        }
    }

    private void editColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            DciSummaryTableColumn column = (DciSummaryTableColumn)selection.getFirstElement();
            EditDciSummaryTableColumnDlg dlg = new EditDciSummaryTableColumnDlg(this.getShell(), column);
            if (dlg.open() == 0) {
                this.viewer.update((Object)column, null);
            }
        }
    }

    private void addColumn() {
        DciSummaryTableColumn column = new DciSummaryTableColumn("", "", 0, ";");
        EditDciSummaryTableColumnDlg dlg = new EditDciSummaryTableColumnDlg(this.getShell(), column);
        if (dlg.open() == 0) {
            this.columns.add(column);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    private void importColumns() {
        SelectDciDialog dialog = new SelectDciDialog(this.getShell(), 0L);
        dialog.setAllowTemplateItems(true);
        dialog.setAllowNoValueObjects(true);
        dialog.setEnableEmptySelection(false);
        if (dialog.open() == 0) {
            List selection = dialog.getSelection();
            ArrayList<DciSummaryTableColumn> select = new ArrayList<DciSummaryTableColumn>();
            for (DciValue item : selection) {
                DciSummaryTableColumn column = new DciSummaryTableColumn(item.getDescription(), item.getName(), 0, ";");
                select.add(column);
                this.columns.add(column);
            }
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(select));
        }
    }
}

