/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.YAxisRangeEditor;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class YAxisRangeEditor
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(YAxisRangeEditor.class);
    private Button radioAuto;
    private Button radioManual;
    private Button checkYBase;
    private LabeledText from;
    private LabeledText to;
    private LabeledText label;
    private Color errorBackground;

    public YAxisRangeEditor(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Group group = new Group((Composite)this, 0);
        group.setText(this.i18n.tr("Y Axis Settings"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        this.radioAuto = new Button((Composite)group, 16);
        this.radioAuto.setText(this.i18n.tr("Automatic range"));
        this.radioAuto.setSelection(true);
        Label spacer = new Label((Composite)group, 0);
        GridData gd = new GridData();
        gd.widthHint = 20;
        spacer.setLayoutData((Object)gd);
        this.checkYBase = new Button((Composite)group, 32);
        this.checkYBase.setText(this.i18n.tr("Set Y base to min value"));
        this.radioManual = new Button((Composite)group, 16);
        this.radioManual.setText(this.i18n.tr("Manual range"));
        this.from = new LabeledText((Composite)group, 0);
        this.from.setLabel(this.i18n.tr("From"));
        this.from.setText("0");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.from.setLayoutData((Object)gd);
        this.to = new LabeledText((Composite)group, 0);
        this.to.setLabel(this.i18n.tr("To"));
        this.to.setText("100");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.to.setLayoutData((Object)gd);
        this.label = new LabeledText((Composite)group, 0);
        this.label.setLabel(this.i18n.tr("Axis label (leave empty to hide)"));
        this.label.setText("");
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.label.setLayoutData((Object)gd);
        1 s = new /* Unavailable Anonymous Inner Class!! */;
        this.radioAuto.addSelectionListener((SelectionListener)s);
        this.radioManual.addSelectionListener((SelectionListener)s);
        this.errorBackground = new Color((Device)this.getDisplay(), 255, 64, 64);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        3 inputValidator = new /* Unavailable Anonymous Inner Class!! */;
        this.from.getTextControl().addModifyListener((ModifyListener)inputValidator);
        this.to.getTextControl().addModifyListener((ModifyListener)inputValidator);
        this.onModeChange();
    }

    private void onModeChange() {
        boolean auto = this.radioAuto.getSelection();
        this.checkYBase.setEnabled(auto);
        this.from.setEnabled(!auto);
        this.to.setEnabled(!auto);
        if (auto) {
            this.from.getTextControl().setBackground(null);
            this.to.getTextControl().setBackground(null);
        } else {
            try {
                Double.parseDouble(this.from.getText().trim());
            }
            catch (NumberFormatException ex) {
                this.from.getTextControl().setBackground(this.errorBackground);
            }
            try {
                Double.parseDouble(this.to.getText().trim());
            }
            catch (NumberFormatException ex) {
                this.to.getTextControl().setBackground(this.errorBackground);
            }
        }
    }

    public void setSelection(boolean auto, boolean modifyYBase, double minY, double maxY, String labelText) {
        this.radioAuto.setSelection(auto);
        this.checkYBase.setSelection(auto && modifyYBase);
        this.radioManual.setSelection(!auto);
        this.from.setText(Double.toString(minY));
        this.to.setText(Double.toString(maxY));
        this.label.setText(labelText);
        this.onModeChange();
    }

    public boolean isAuto() {
        return this.radioAuto.getSelection();
    }

    public boolean modifyYBase() {
        return this.checkYBase.getSelection();
    }

    public double getMinY() {
        try {
            return Double.parseDouble(this.from.getText().trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public double getMaxY() {
        try {
            return Double.parseDouble(this.to.getText().trim());
        }
        catch (NumberFormatException e) {
            return 100.0;
        }
    }

    public String getLabel() {
        return this.label.getText().trim();
    }

    public boolean validate(boolean showErrorMessage) {
        if (this.isAuto()) {
            return true;
        }
        try {
            Double.parseDouble(this.from.getText().trim());
            Double.parseDouble(this.to.getText().trim());
            return true;
        }
        catch (NumberFormatException e) {
            if (showErrorMessage) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Y axis range is invalid. Please enter correct values."));
            }
            return false;
        }
    }
}

