/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Event;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.helpers.AbstractTraceViewFilter;
import org.netxms.nxmc.modules.events.widgets.helpers.HistoricalEvent;

public class EventMonitorFilter
extends AbstractTraceViewFilter {
    private NXCSession session = Registry.getSession();
    private int[] eventCodes = null;

    public void setEventCodes(int[] codes) {
        this.eventCodes = codes != null && codes.length > 0 ? codes : null;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AbstractObject object;
        int code;
        String message;
        long sourceId;
        if (element instanceof Event) {
            event = (Event)element;
            sourceId = event.getSourceId();
            message = event.getMessage();
            code = event.getCode();
        } else if (element instanceof HistoricalEvent) {
            event = (HistoricalEvent)element;
            sourceId = event.getSourceId();
            message = event.getMessage();
            code = event.getCode();
        } else {
            return false;
        }
        if (this.eventCodes != null) {
            boolean found = false;
            for (int allowedCode : this.eventCodes) {
                if (code != allowedCode) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (!(this.rootObjectId == 0L || this.rootObjectId == sourceId || (object = this.session.findObjectById(sourceId)) != null && object.isChildOf(this.rootObjectId))) {
            return false;
        }
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        return message.toLowerCase().contains(this.filterString) || this.session.getEventName(code).toLowerCase().contains(this.filterString) || this.session.getObjectName(sourceId).toLowerCase().contains(this.filterString);
    }
}

