/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets.helpers;

import java.util.Date;
import org.netxms.client.TableRow;
import org.netxms.client.constants.Severity;

public class HistoricalEvent {
    private final long id;
    private final int code;
    private final Date timeStamp;
    private final long sourceId;
    private final long dciId;
    private final Severity severity;
    private final String message;

    public HistoricalEvent(TableRow row, int idxId, int idxTimestamp, int idxSource, int idxCode, int idxSeverity, int idxMessage, int idxDciId) {
        this.id = row.getValueAsLong(idxId);
        this.timeStamp = new Date(row.getValueAsLong(idxTimestamp) * 1000L);
        this.sourceId = row.getValueAsLong(idxSource);
        this.code = (int)row.getValueAsLong(idxCode);
        this.severity = Severity.getByValue((int)((int)row.getValueAsLong(idxSeverity)));
        this.message = row.get(idxMessage).getValue();
        this.dciId = idxDciId >= 0 ? row.getValueAsLong(idxDciId) : 0L;
    }

    public long getId() {
        return this.id;
    }

    public int getCode() {
        return this.code;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }
}

