/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.PasswordInputField;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectSelectionFilterFactory;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.SNMP;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SNMP
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(SNMP.class);
    private AbstractNode node;
    private Combo snmpVersion;
    private LabeledText snmpPort;
    private Combo snmpAuth;
    private Combo snmpPriv;
    private ObjectSelector snmpProxy;
    private PasswordInputField snmpAuthName;
    private PasswordInputField snmpAuthPassword;
    private PasswordInputField snmpPrivPassword;
    private LabeledText snmpCodepage;
    private Button snmpSettingsLocked;

    public SNMP(AbstractObject object) {
        super(LocalizationHelper.getI18n(SNMP.class).tr("SNMP"), object);
    }

    public String getId() {
        return "communication.snmp";
    }

    public String getParentId() {
        return "communication";
    }

    public boolean isVisible() {
        return this.object instanceof AbstractNode;
    }

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.object;
        Composite dialogArea = new Composite(parent, 0);
        FormLayout dialogLayout = new FormLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.spacing = 5;
        dialogArea.setLayout((Layout)dialogLayout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        this.snmpVersion = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)this.i18n.tr("Version"), (Object)fd);
        this.snmpVersion.add("1");
        this.snmpVersion.add("2c");
        this.snmpVersion.add("3");
        this.snmpVersion.select(this.snmpVersionToIndex(this.node.getSnmpVersion()));
        this.snmpVersion.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.snmpPort = new LabeledText(dialogArea, 0);
        this.snmpPort.setLabel(this.i18n.tr("UDP Port"));
        this.snmpPort.setText(Integer.toString(this.node.getSnmpPort()));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 1024);
        this.snmpAuth = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)this.i18n.tr("Authentication"), (Object)fd);
        this.snmpAuth.add(this.i18n.tr("NONE"));
        this.snmpAuth.add(this.i18n.tr("MD5"));
        this.snmpAuth.add(this.i18n.tr("SHA1"));
        this.snmpAuth.add("SHA224");
        this.snmpAuth.add("SHA256");
        this.snmpAuth.add("SHA384");
        this.snmpAuth.add("SHA512");
        this.snmpAuth.select(this.node.getSnmpAuthMethod());
        this.snmpAuth.setEnabled(this.node.getSnmpVersion() == SnmpVersion.V3);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 131072);
        fd.top = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 1024);
        this.snmpPriv = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)this.i18n.tr("Encryption"), (Object)fd);
        this.snmpPriv.add(this.i18n.tr("NONE"));
        this.snmpPriv.add("DES");
        this.snmpPriv.add("AES-128");
        this.snmpPriv.add("AES-192");
        this.snmpPriv.add("AES-256");
        this.snmpPriv.select(this.node.getSnmpPrivMethod());
        this.snmpPriv.setEnabled(this.node.getSnmpVersion() == SnmpVersion.V3);
        this.snmpProxy = new ObjectSelector(dialogArea, 0, true);
        this.snmpProxy.setLabel(this.i18n.tr("Proxy"));
        this.snmpProxy.setClassFilter(ObjectSelectionFilterFactory.getInstance().createNodeSelectionFilter(false));
        this.snmpProxy.setObjectId(this.node.getSnmpProxyId());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 1024);
        fd.right = new FormAttachment((Control)this.snmpPriv.getParent(), 0, 131072);
        this.snmpProxy.setLayoutData((Object)fd);
        this.snmpAuthName = new PasswordInputField(dialogArea, 0);
        this.snmpAuthName.setLabel(this.node.getSnmpVersion() == SnmpVersion.V3 ? this.i18n.tr("User name") : this.i18n.tr("Community string"));
        this.snmpAuthName.setText(this.node.getSnmpAuthName());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpProxy, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.snmpAuthName.setLayoutData((Object)fd);
        this.snmpAuthPassword = new PasswordInputField(dialogArea, 0);
        this.snmpAuthPassword.setLabel(this.i18n.tr("Authentication password"));
        this.snmpAuthPassword.setText(this.node.getSnmpAuthPassword());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 128);
        fd.right = new FormAttachment(100, 0);
        this.snmpAuthPassword.setLayoutData((Object)fd);
        this.snmpAuthPassword.setInputControlsEnabled(this.node.getSnmpVersion() == SnmpVersion.V3);
        this.snmpPrivPassword = new PasswordInputField(dialogArea, 0);
        this.snmpPrivPassword.setLabel(this.i18n.tr("Encryption password"));
        this.snmpPrivPassword.setText(this.node.getSnmpPrivPassword());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment((Control)this.snmpProxy, 0, 128);
        fd.right = new FormAttachment(100, 0);
        this.snmpPrivPassword.setLayoutData((Object)fd);
        this.snmpPrivPassword.setInputControlsEnabled(this.node.getSnmpVersion() == SnmpVersion.V3);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 131072);
        fd.right = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment(0, 0);
        this.snmpPort.setLayoutData((Object)fd);
        this.snmpCodepage = new LabeledText(dialogArea, 0);
        this.snmpCodepage.setLabel(this.i18n.tr("Codepage"));
        this.snmpCodepage.setText(this.node.getSNMPCodepage());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.snmpProxy, 0, 1024);
        this.snmpCodepage.setLayoutData((Object)fd);
        this.snmpSettingsLocked = new Button(dialogArea, 32);
        this.snmpSettingsLocked.setText(this.i18n.tr("&Prevent automatic SNMP configuration changes"));
        this.snmpSettingsLocked.setSelection(this.node.isSnmpSettingsLocked());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.snmpCodepage, 0, 1024);
        this.snmpSettingsLocked.setLayoutData((Object)fd);
        return dialogArea;
    }

    private int snmpVersionToIndex(SnmpVersion version) {
        switch (3.$SwitchMap$org$netxms$client$snmp$SnmpVersion[version.ordinal()]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    private SnmpVersion snmpIndexToVersion(int index) {
        SnmpVersion[] versions = new SnmpVersion[]{SnmpVersion.V1, SnmpVersion.V2C, SnmpVersion.V3};
        return versions[index];
    }

    private void onSnmpVersionChange() {
        boolean isV3 = this.snmpVersion.getSelectionIndex() == 2;
        this.snmpAuthName.setLabel(isV3 ? this.i18n.tr("User name") : this.i18n.tr("Community string"));
        this.snmpAuth.setEnabled(isV3);
        this.snmpPriv.setEnabled(isV3);
        this.snmpAuthPassword.setInputControlsEnabled(isV3);
        this.snmpPrivPassword.setInputControlsEnabled(isV3);
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        md.setSnmpVersion(this.snmpIndexToVersion(this.snmpVersion.getSelectionIndex()));
        try {
            md.setSnmpPort(Integer.parseInt(this.snmpPort.getText(), 10));
        }
        catch (NumberFormatException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid SNMP port number"));
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        md.setSnmpProxy(this.snmpProxy.getObjectId());
        md.setSnmpAuthentication(this.snmpAuthName.getText(), this.snmpAuth.getSelectionIndex(), this.snmpAuthPassword.getText(), this.snmpPriv.getSelectionIndex(), this.snmpPrivPassword.getText());
        md.setSNMPCodepage(this.snmpCodepage.getText());
        int flags = this.node.getFlags();
        flags = this.snmpSettingsLocked.getSelection() ? (flags |= 0x2000000) : (flags &= 0xFDFFFFFF);
        md.setObjectFlags((long)flags, 0x2000000L);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.snmpVersion.select(0);
        this.snmpAuth.select(0);
        this.snmpPriv.select(0);
        this.snmpAuthName.setText("public");
        this.snmpAuthPassword.setText("");
        this.snmpPrivPassword.setText("");
        this.snmpProxy.setObjectId(0L);
        this.onSnmpVersionChange();
        this.snmpCodepage.setText("");
    }
}

