/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.views.ChassisView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.ChassisWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.ElementSelectionListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;

public class ChassisView
extends ObjectView
implements ISelectionProvider {
    private ScrolledComposite scroller;
    private Composite content;
    private ChassisWidget chassisFrontWidget;
    private ChassisWidget chassisRearWidget;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();

    public ChassisView() {
        super(LocalizationHelper.getI18n(ChassisView.class).tr("Chassis"), ResourceManager.getImageDescriptor((String)"icons/object-views/chassis.png"), "objects.chassis", false);
    }

    protected ChassisView(String subId) {
        super(LocalizationHelper.getI18n(ChassisView.class).tr("Chassis"), ResourceManager.getImageDescriptor((String)"icons/object-views/chassis.png"), "objects.chassis." + subId, false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Chassis;
    }

    public int getPriority() {
        return 15;
    }

    protected void createContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 256);
        this.content = new /* Unavailable Anonymous Inner Class!! */;
        this.content.setBackground(ThemeEngine.getBackgroundColor((String)"Rack"));
        this.content.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.scroller.setContent((Control)this.content);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateChassisWidgetsSize() {
        int width = this.content.getSize().x;
        int height = this.content.getSize().y;
        Point size = this.chassisFrontWidget.computeSize(width, height, true);
        this.chassisFrontWidget.setSize(size);
        this.chassisRearWidget.setSize(size);
        this.chassisRearWidget.setLocation(0, size.y);
    }

    private void createPopupMenu() {
        ObjectContextMenuManager menuMgr = new ObjectContextMenuManager((View)this, (ISelectionProvider)this, null);
        Menu menu = menuMgr.createContextMenu((Control)this.chassisFrontWidget);
        this.chassisFrontWidget.setMenu(menu);
        menu = menuMgr.createContextMenu((Control)this.chassisRearWidget);
        this.chassisRearWidget.setMenu(menu);
    }

    protected void onObjectChange(AbstractObject object) {
        if (this.chassisFrontWidget != null) {
            this.chassisFrontWidget.dispose();
            this.chassisFrontWidget = null;
        }
        if (this.chassisRearWidget != null) {
            this.chassisRearWidget.dispose();
            this.chassisRearWidget = null;
        }
        if (object != null) {
            this.buildViewForChassis((Chassis)object);
        }
    }

    protected void buildViewForChassis(Chassis chassis) {
        4 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.chassisFrontWidget = new ChassisWidget(this.content, 0, chassis, RackOrientation.FRONT, true);
        this.chassisFrontWidget.addSelectionListener((ElementSelectionListener)listener);
        this.chassisRearWidget = new ChassisWidget(this.content, 0, chassis, RackOrientation.REAR, true);
        this.chassisRearWidget.addSelectionListener((ElementSelectionListener)listener);
        this.scroller.setMinSize(this.content.computeSize(this.scroller.getSize().x, -1));
        this.updateChassisWidgetsSize();
        this.createPopupMenu();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

