/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public abstract class ObjectView
extends ViewWithContext {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectView.class);
    protected NXCSession session = Registry.getSession();
    private SessionListener clientListener;

    public ObjectView(String name, ImageDescriptor image, String id, boolean hasFilter) {
        super(name, image, id, hasFilter);
    }

    public String getGlobalId() {
        return this.getBaseId() + "@" + Long.toString(this.getObjectId());
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.setupClientListener();
        if (this.getObject() != null) {
            this.setContext((Object)this.getObject());
        }
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.setupClientListener();
    }

    private void setupClientListener() {
        this.clientListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.clientListener);
    }

    protected void onObjectUpdate(AbstractObject object) {
    }

    protected boolean isRelatedObject(long objectId) {
        return false;
    }

    protected String getContextName() {
        AbstractObject object = this.getObject();
        return object != null ? object.getObjectName() : this.i18n.tr("[none]");
    }

    public boolean isHidden() {
        return PreferenceStore.getInstance().getAsBoolean("HideView." + this.getBaseId(), false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractObject;
    }

    protected void contextChanged(Object oldContext, Object newContext) {
        this.onObjectChange((AbstractObject)newContext);
    }

    protected void onObjectChange(AbstractObject object) {
    }

    public AbstractObject getObject() {
        return (AbstractObject)this.getContext();
    }

    public long getObjectId() {
        AbstractObject object = (AbstractObject)this.getContext();
        return object != null ? object.getObjectId() : 0L;
    }

    public String getObjectName() {
        AbstractObject object = (AbstractObject)this.getContext();
        return object != null ? object.getObjectName() : "";
    }

    public void dispose() {
        this.session.removeListener(this.clientListener);
        super.dispose();
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("context", this.getObjectId());
    }

    public Object restoreContext(Memento memento) {
        long objectId = memento.getAsLong("context", 0L);
        return this.session.findObjectById(objectId);
    }

    static /* synthetic */ void access$000(ObjectView x0, Object x1, boolean x2) {
        x0.setContext(x1, x2);
    }
}

